/*
 * Decompiled with CFR 0.152.
 */
package ork;

import cqure.repeng.ReportObject;
import cqure.repeng.ReportTree;
import gnu.getopt.Getopt;
import java.beans.XMLDecoder;
import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import ork.CommonValuesDB;
import ork.Logger;
import ork.OracleDBConnection;
import ork.PluginList;
import ork.SIDList;
import ork.ScannerConfig;
import ork.ServerList;
import ork.ServerResult;
import ork.plugins.PluginIface;

public class OracleScanner {
    static Connection m_oConn = null;
    private static String m_sConnURL = null;
    private static Logger oLogger = new Logger();
    private static OracleDBConnection oOraDBConn = new OracleDBConnection();
    private static String m_sVersion = "1.0.6";
    private static String m_sAuthor = "patrik@cqure.net";
    static /* synthetic */ Class class$0;

    public static void usage() {
        System.out.println("\tOracle Scanner " + m_sVersion + " by " + m_sAuthor);
        System.out.println("\t--------------------------------------");
        System.out.println("\tOracleScanner -s <ip> -r <repfile> [options]");
        System.out.println("\t\t-s\t<servername>");
        System.out.println("\t\t-f\t<serverlist>");
        System.out.println("\t\t-P\t<portnr>");
        System.out.println("\t\t-v\tbe verbose");
        System.out.println("");
    }

    public static ScannerConfig loadScannerConfig(String s) {
        FileInputStream oFIS = null;
        XMLDecoder oDecoder = null;
        ScannerConfig oConf = null;
        try {
            oFIS = new FileInputStream(s);
            oDecoder = new XMLDecoder(oFIS);
            oConf = (ScannerConfig)oDecoder.readObject();
            oDecoder.close();
            oFIS.close();
        }
        catch (Exception e) {
            System.err.println("[x] Failed to load report");
            e.printStackTrace();
            return null;
        }
        return oConf;
    }

    public static void main(String[] args) {
        String sTmp;
        int c;
        String sHostName = null;
        Object sLocalIP = null;
        String sRepFile = null;
        int nOraclePort = 1521;
        Getopt oOpt = new Getopt("OracleScanner", args, "s:f:P:v");
        PluginList oPlugList = null;
        ServerList oSrvList = new ServerList();
        ScannerConfig oConfig = null;
        SIDList oSIDList = null;
        String sConfigFile = "default.conf";
        ReportTree oTree = new ReportTree();
        block11: while ((c = oOpt.getopt()) != -1) {
            switch (c) {
                case 115: {
                    String arg = oOpt.getOptarg();
                    oSrvList.addServer(arg);
                    break;
                }
                case 80: {
                    String arg = oOpt.getOptarg();
                    nOraclePort = Integer.parseInt(arg);
                    oOraDBConn.setPort(nOraclePort);
                    break;
                }
                case 118: {
                    oLogger.setLogLevel(5);
                    break;
                }
                case 111: {
                    String arg = oOpt.getOptarg();
                    if (oLogger.setLogFile(arg) == 0) continue block11;
                    System.err.println("[x] Failed to create logger");
                    System.exit(0);
                    break;
                }
                case 102: {
                    String arg = oOpt.getOptarg();
                    if (oSrvList.loadServerList(arg) == 0) continue block11;
                    System.err.println("[x] failed to open serverlist");
                    System.exit(0);
                    break;
                }
                default: {
                    OracleScanner.usage();
                    System.exit(0);
                }
            }
        }
        if (oSrvList.getServerCount() == 0 || nOraclePort == -1) {
            OracleScanner.usage();
            System.exit(0);
        }
        oConfig = new ScannerConfig();
        oConfig = OracleScanner.loadScannerConfig(sConfigFile);
        if (oConfig == null) {
            System.err.println("[x] Failed to load configfile: " + sConfigFile);
            System.exit(0);
        }
        if ((sTmp = oConfig.getConfigOption("oracleplugins")) == null) {
            System.err.println("[x] Failed to load Oracle pluginlist from file " + sTmp);
            System.exit(0);
        }
        if ((oPlugList = new PluginList()).loadFromFile(oConfig.getConfigOption("oracleplugins")) != 0) {
            System.err.println("[x] Failed to open plugin list: " + oConfig.getConfigOption("oracleplugins"));
            System.exit(1);
        }
        oLogger.log("Oracle Scanner " + m_sVersion + " by " + m_sAuthor);
        oLogger.log("--------------------------------------------------");
        while ((sHostName = oSrvList.getNextServer()) != null) {
            oLogger.log("[-] Checking host " + sHostName);
            oOraDBConn.setHost(sHostName);
            oTree.addReportItem(null, new ReportObject(sHostName));
            ServerResult oRes = new ServerResult(sHostName, nOraclePort);
            CommonValuesDB oCommDB = new CommonValuesDB();
            Object plug = null;
            oRes.setSIDList(oSIDList);
            int i = 0;
            while (i < oPlugList.size()) {
                try {
                    Class<?> cl = Class.forName((String)oPlugList.get(i));
                    Class[] classArray = new Class[1];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("ork.ServerResult");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz;
                    Constructor<?> oCt = cl.getConstructor(classArray);
                    plug = oCt.newInstance(oRes);
                    ((PluginIface)plug).setLogger(oLogger);
                    ((PluginIface)plug).setConfig(oConfig);
                    ((PluginIface)plug).setCommonValuesDB(oCommDB);
                    ((PluginIface)plug).setReportTree(oTree);
                    if (((PluginIface)plug).scan() != 0) {
                        oLogger.log("Plugin " + (String)oPlugList.get(i) + " failed");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
            sRepFile = "oscanner_" + sHostName.replace('.', '_') + "_report.xml";
            oTree.storeToFile(sRepFile);
            oTree = null;
            oTree = new ReportTree();
        }
    }
}

