documentation_complete: true

hidden: true

title: Default Profile for Ubuntu 20.04

description: |-
    This profile contains all the rules that once belonged to the
    ubuntu2004 product via 'prodtype'. This profile won't
    be rendered into an XCCDF Profile entity, nor it will select any
    of these rules by default. The only purpose of this profile
    is to keep a rule in the product's XCCDF Benchmark.

selections:
    - grub2_enable_iommu_force
    - kernel_config_module_sig_key
    - grub2_rng_core_default_quality_argument
    - kernel_config_debug_list
    - gnome_gdm_disable_xdmcp
    - package_MFEhiplsm_installed
    - grub2_nosmep_argument_absent
    - configure_user_data_backups
    - accounts_polyinstantiated_var_tmp
    - kernel_config_page_table_isolation
    - kernel_config_module_sig_sha512
    - kernel_config_slub_debug
    - kernel_config_page_poisoning_no_sanity
    - audit_rules_media_export
    - rsyslog_encrypt_offload_defaultnetstreamdriver
    - coredump_disable_storage
    - kernel_config_seccomp
    - auditd_data_retention_max_log_file_action_stig
    - sysctl_net_ipv6_conf_default_disable_ipv6
    - audit_rules_usergroup_modification
    - kernel_config_security_yama
    - sshd_set_loglevel_verbose
    - audit_rules_dac_modification_umount
    - kernel_module_uvcvideo_disabled
    - sshd_disable_user_known_hosts
    - sudoers_no_command_negation
    - auditd_name_format
    - no_password_auth_for_systemaccounts
    - restrict_serial_port_logins
    - auditd_local_events
    - kernel_config_default_mmap_min_addr
    - kernel_config_hibernation
    - set_iptables_default_rule_forward
    - sysctl_net_ipv4_conf_all_arp_filter
    - account_use_centralized_automated_auth
    - kernel_config_seccomp_filter
    - sshd_rekey_limit
    - kernel_config_security
    - sysctl_net_ipv6_conf_all_disable_ipv6
    - sudo_vdsm_nopasswd
    - kernel_config_security_writable_hooks
    - fapolicyd_prevent_home_folder_access
    - kernel_config_binfmt_misc
    - zipl_audit_argument
    - sshd_enable_warning_banner
    - audit_rules_dac_modification_umount2
    - kernel_config_security_dmesg_restrict
    - package_postfix_installed
    - sysctl_net_ipv4_conf_all_accept_local
    - audit_privileged_commands_poweroff
    - sysctl_kernel_kptr_restrict
    - sudoers_no_root_target
    - auditd_write_logs
    - grub2_mce_argument
    - coredump_disable_backtraces
    - kernel_config_kexec
    - accounts_polyinstantiated_tmp
    - rsyslog_remote_loghost
    - kernel_disable_entropy_contribution_for_solid_state_drives
    - avahi_disable_publishing
    - sshd_use_priv_separation
    - audit_privileged_commands_shutdown
    - file_groupownership_sshd_pub_key
    - account_passwords_pam_faillock_dir
    - kernel_config_devkmem
    - kernel_config_panic_timeout
    - kernel_config_debug_credentials
    - file_ownership_var_log_audit
    - kernel_config_legacy_ptys
    - file_ownership_sshd_private_key
    - kernel_config_panic_on_oops
    - grub2_systemd_debug-shell_argument_absent
    - service_netfs_disabled
    - ftp_limit_users
    - file_groupownership_sshd_private_key
    - kernel_module_ipv6_option_disabled
    - rsyslog_accept_remote_messages_tcp
    - audit_rules_privileged_commands
    - auditd_data_disk_full_action_stig
    - file_ownership_sshd_pub_key
    - kernel_config_randomize_memory
    - sudo_add_requiretty
    - package_ntp_installed
    - sshd_disable_compression
    - sshd_disable_gssapi_auth
    - sshd_enable_gssapi_auth
    - kernel_config_debug_sg
    - sshd_print_last_log
    - auditd_data_retention_admin_space_left_percentage
    - grub2_nosmap_argument_absent
    - kernel_config_module_sig_hash
    - partition_for_dev_shm
    - kernel_config_randomize_base
    - sysctl_net_ipv4_conf_default_shared_media
    - grub2_l1tf_argument
    - ftp_configure_firewall
    - auditd_data_disk_error_action
    - kernel_config_x86_vsyscall_emulation
    - kernel_config_debug_notifiers
    - kernel_config_proc_kcore
    - auditd_overflow_action
    - zipl_audit_backlog_limit_argument
    - service_systemd-journald_enabled
    - sshd_allow_only_protocol2
    - sysctl_net_ipv4_conf_all_arp_ignore
    - grub2_spectre_v2_argument
    - kernel_config_ipv6
    - file_permissions_home_dirs
    - grub2_disable_recovery
    - postfix_client_configure_mail_alias_postmaster
    - securetty_root_login_console_only
    - file_permissions_var_log_messages
    - no_direct_root_logins
    - sshd_set_keepalive_0
    - accounts_password_minlen_login_defs
    - selinux_not_disabled
    - package_nss-tools_installed
    - sysctl_net_ipv4_conf_all_shared_media
    - sshd_enable_strictmodes
    - root_path_no_dot
    - sudo_remove_nopasswd
    - kernel_config_bug
    - kernel_config_page_poisoning_zero
    - package_logrotate_installed
    - kernel_config_compat_vdso
    - postfix_client_configure_mail_alias
    - package_xorg-x11-server-common_removed
    - service_iptables_enabled
    - postfix_client_configure_relayhost
    - audit_privileged_commands_init
    - iptables_sshd_disabled
    - chronyd_server_directive
    - kernel_config_compat_brk
    - grub2_spec_store_bypass_disable_argument
    - sudo_remove_no_authenticate
    - kernel_config_unmap_kernel_at_el0
    - service_postfix_enabled
    - package_openssh-server_removed
    - partition_for_srv
    - sudo_add_noexec
    - sysctl_net_ipv4_conf_all_route_localnet
    - ufw_rules_for_open_ports
    - auditd_log_format
    - service_syslogng_enabled
    - kernel_config_retpoline
    - kernel_config_debug_fs
    - account_passwords_pam_faillock_audit
    - disallow_bypass_password_sudo
    - sudoers_explicit_command_args
    - auditd_data_retention_num_logs
    - prefer_64bit_os
    - sshd_enable_x11_forwarding
    - service_sshd_disabled
    - sshd_disable_rhosts_rsa
    - sysctl_kernel_panic_on_oops
    - file_permissions_audit_configuration
    - harden_ssh_client_crypto_policy
    - dhcp_server_minimize_served_info
    - no_all_squash_exports
    - sshd_disable_kerb_auth
    - accounts_logon_fail_delay
    - selinux_state
    - file_groupowner_var_log_messages
    - auditd_audispd_syslog_plugin_activated
    - kernel_config_acpi_custom_method
    - sshd_disable_pubkey_auth
    - package_gnutls-utils_installed
    - dhcp_client_restrict_options
    - audit_privileged_commands_reboot
    - auditd_freq
    - rsyslog_encrypt_offload_actionsendstreamdrivermode
    - kernel_config_module_sig_all
    - rsyslog_encrypt_offload_actionsendstreamdriverauthmode
    - kernel_config_syn_cookies
    - package_syslogng_installed
    - auditd_data_disk_error_action_stig
    - accounts_password_all_shadowed
    - kernel_config_ia32_emulation
    - rsyslog_accept_remote_messages_udp
    - file_owner_var_log_messages
    - package_gdm_removed
    - installed_OS_is_FIPS_certified
    - grub2_slab_nomerge_argument
    - kernel_config_module_sig
    - sshd_disable_root_password_login
    - audit_rules_mac_modification_usr_share
    - kernel_config_module_sig_force
    - audit_rules_mac_modification
    - service_ip6tables_enabled
