#version 330


layout(points) in;
layout(triangle_strip, max_vertices = 80) out;
//layout(line_strip, max_vertices = 80) out;

// input position and color
in vec4 vertPosition[];
in vec3 lightDirection[];
in vec3 ed[];
uniform float angle;
uniform vec4 Color;

out vec3 Normal;
out vec3 _lightDirection;
out vec3 uv;
out vec3 eye;
flat out int wall;
flat out vec3 flatNormal;

out gl_PerVertex{
  vec4 gl_Position;
};

const float PI = 3.14159265359;

vec4 farbverlauf(float wrt, float _min, float _max){
if (_min+0.001>=_max)_max+=0.002;
vec4 ff;
int lauf=0;
const vec4 farbe[]= vec4[6](
  vec4(1.0,0.0,0.0,1.0),
  vec4(1.0,1.0,0.0,1.0),
  vec4(0.0,1.0,0.0,1.0),
  vec4(0.0,1.0,1.0,1.0),
  vec4(0.0,0.0,1.0,1.0),
  vec4(1.0,0.0,1.0,1.0));
float nwrt = (wrt - _min) / (_max - _min);
nwrt=(nwrt >= 1.0)?0.99999:nwrt;
nwrt=(nwrt <= 0.0)?0.00001:nwrt;
lauf=(int (nwrt/0.2));
nwrt-=(0.2*lauf);
nwrt/=(0.2);
ff=vec4((1.0-nwrt)*farbe[lauf][0]+farbe[lauf+1][0]*nwrt, (1.0-nwrt)*farbe[lauf][1]+farbe[lauf+1][1]*nwrt,
        (1.0-nwrt)*farbe[lauf][2]+farbe[lauf+1][2]*nwrt, 1.0);
return ff;
}


mat4 rmat(vec4 arr){
  float phi=arr.x/180*PI;
  float c=cos(phi);
  float s=sin(phi);
  float omc=1.0-c;
  vec3 ar = arr.yzw;
  mat4 m =
  mat4(c+ar.x*ar.x*omc,ar.x*ar.y*omc-s*ar.z,ar.x*ar.z*omc+s*ar.y,0,
      ar.x*ar.y*omc+s*ar.z,c+ar.y*ar.y*omc,ar.y*ar.z*omc-s*ar.x,0,
      ar.x*ar.z*omc-s*ar.y,ar.y*ar.z*omc+s*ar.x,c+ar.z*ar.z*omc,0,
      0,0,0,1);

  return m;
}

void icosa(float r){
  const float phi = (1.0 + sqrt(5.0)) / 2.0;
  const float du = 1.0 / sqrt(phi * phi + 1.0);
  const float dv = phi * du;
  //const float ang = 140.0 /180.0 *3.141592654;
  /*mat4(
  vec4( cos(angle),        0, sin(angle), 0),
  vec4(        0,        1,        0, 0),
  vec4(-sin(angle),        0, cos(angle), 0),
  vec4(        0,        0,        0, 1));*/
  mat4 rot = rmat(vec4(angle, normalize(vec3(1,1,0))));
  const vec3  eckn[] = vec3[12](vec3(0.0, dv, du),   vec3(0.0, dv, -du),  vec3(0.0, -dv, du),
                          vec3(0.0, -dv, -du), vec3(du, 0.0, dv),   vec3(-du, 0.0, dv),
                          vec3(du, 0.0, -dv),  vec3(-du, 0.0, -dv), vec3(dv, du, 0.0),
                          vec3(dv, -du, 0.0),  vec3(-dv, du, 0.0),  vec3(-dv, -du, 0.0));
  /*const int triangle[] = int[60](0, 1, 8, 0, 4, 5, 0, 5, 10, 0, 8, 4, 0, 10, 1, 1, 6, 8, 1, 7, 6,  1, 10, 7, 2, 3, 11, 2, 4, 9, 2, 5, 4, 2, 9, 3,
  2, 11, 5, 3, 6, 7, 3, 7, 11, 3, 9, 6, 4, 8, 9, 5, 11, 10, 6, 9, 8,  7, 10, 11);
  int j=0;
  vec3 N=vec3(1,0,0);
  for (int j=0; j<60; j++){
      gl_Position = vertPosition[0] + rot * vec4(0.3 * eckn[triangle[j]],1.0);
      geomColor= vertColor[0];//farbverlauf(j/3,0,20);//col[triangle[j]];// vertColor[0];//
      Normal = normalize(eckn[triangle[j]]);
      if (j%3 ==0) N = normalize(eckn[triangle[j]]+eckn[triangle[j+1]]+eckn[triangle[j+2]]);
      //Normal = normalize(cross((eckn[triangle[j]]-eckn[triangle[j+1]]),(eckn[triangle[j+2]]-eckn[triangle[j+1]])));//normalize(eckn[triangle[j]]);
      flatNormal = N;
      _lightDirection = mat3(transpose(rot))* lightDirection[0];
      eye = mat3(transpose(rot)) * ed[0];
      wall = 0;
      EmitVertex();
    if (j%3 == 2)EndPrimitive();
  }
// */
//*
  const int strip[] = int[37](0, 1, 8, 0, 4, 5, 0, 10, 5, 11, 2, 3, 9, 6, 3, 7, 6, 1, 8,
    6, 9, 8, 4, 9, 2, 4, 5, 2, 11, 3, 7, 11, 10, 7, 1, 10, 0);
  for (int i=0; i< strip.length(); i++){
    uv = eckn[strip[i]];
    gl_Position = vertPosition[0] + rot * vec4(r * eckn[strip[i]],1.0);
    if (i+2 < strip.length()) flatNormal = normalize(eckn[strip[i]]+eckn[strip[i+1]]+eckn[strip[i+2]]);
    Normal =  normalize(eckn[strip[i]]);
    _lightDirection = mat3(transpose(rot))* lightDirection[0];
    wall = 0;
    eye = mat3(transpose(rot)) * ed[0];
    EmitVertex();
  }// */
  EndPrimitive();
}

void pappe(float r){
mat4 rot = rmat(vec4(angle, normalize(vec3(1,1,0))));
const vec4 red=   vec4(1.0,0.0,0.0,1.0);
const vec4 green= vec4(0.0,1.0,0.0,1.0);
const vec4 blue=  vec4(0.0,0.0,1.0,1.0);
gl_Position = vertPosition[0] + rot * vec4(-r,-r,0.0,1.0);
Normal = vec3(0,0,1.0);
wall = 1;
uv = normalize(vec3(-r,-r,0));
_lightDirection = mat3(transpose(rot)) * lightDirection[0];//transpose of rotation matrix is its inverse right?
eye = mat3(transpose(rot)) * ed[0];
EmitVertex();

gl_Position = vertPosition[0] + rot * vec4( r,-r,0.0,1.0);
Normal = vec3(0,0,1.0);
wall = 1;
uv = normalize(vec3( r,-r,0));
_lightDirection = mat3(transpose(rot)) * lightDirection[0];//transpose of rotation matrix is its inverse right?
eye = mat3(transpose(rot)) * ed[0];
EmitVertex();

gl_Position = vertPosition[0] + rot * vec4(-r, r,0.0,1.0);
Normal = vec3(0,0,1.0);
wall = 1;
uv = normalize(vec3(-r, r,0));
_lightDirection = mat3(transpose(rot)) * lightDirection[0];//transpose of rotation matrix is its inverse right?
eye = mat3(transpose(rot)) * ed[0];
EmitVertex();

gl_Position = vertPosition[0] + rot * vec4( r, r,0.0,1.0);
Normal = vec3(0,0,1.0);
wall = 1;
uv = normalize(vec3( r, r,0));
_lightDirection = mat3(transpose(rot)) * lightDirection[0];//transpose of rotation matrix is its inverse right?
eye = mat3(transpose(rot)) * ed[0];
EmitVertex();

EndPrimitive();

gl_Position = vertPosition[0] + rot * vec4(-r,0,-r,1.0);
Normal = vec3(0,1.0,0);
wall = 1;
uv = normalize(vec3(-r,0,-r));
_lightDirection = mat3(transpose(rot)) * lightDirection[0];//transpose of rotation matrix is its inverse right?
eye = mat3(transpose(rot)) * ed[0];
EmitVertex();

gl_Position = vertPosition[0] + rot * vec4( r,0,-r,1.0);
Normal = vec3(0,1.0,0);
wall = 1;
uv = normalize(vec3( r,0,-r));
_lightDirection = mat3(transpose(rot)) * lightDirection[0];//transpose of rotation matrix is its inverse right?
eye = mat3(transpose(rot)) * ed[0];
EmitVertex();

gl_Position = vertPosition[0] + rot * vec4(-r,0,r,1.0);
Normal = vec3(0,1.0,0);
wall = 1;
uv = normalize(vec3(-r,0, r));
_lightDirection = mat3(transpose(rot)) * lightDirection[0];//transpose of rotation matrix is its inverse right?
eye = mat3(transpose(rot)) * ed[0];
EmitVertex();

gl_Position = vertPosition[0] + rot * vec4( r,0,r,1.0);
Normal = vec3(0,1.0,0);wall = 1;
uv = normalize(vec3( r,0, r));
_lightDirection = mat3(transpose(rot)) * lightDirection[0];//transpose of rotation matrix is its inverse right?
eye = mat3(transpose(rot)) * ed[0];
EmitVertex();
EndPrimitive();


gl_Position = vertPosition[0] + rot * vec4(0,-r,-r,1.0);
Normal = vec3(1.0,0,0);
wall = 1;
uv = normalize(vec3(0,-r,-r));
_lightDirection = mat3(transpose(rot)) * lightDirection[0];//transpose of rotation matrix is its inverse right?
eye = mat3(transpose(rot)) * ed[0];
EmitVertex();

gl_Position = vertPosition[0] + rot * vec4(0,r, -r,1.0);
Normal = vec3(1.0,0,0);
wall = 1;
uv = normalize(vec3(0, r,-r));
_lightDirection = mat3(transpose(rot)) * lightDirection[0];//transpose of rotation matrix is its inverse right?
eye = mat3(transpose(rot)) * ed[0];
EmitVertex();

gl_Position = vertPosition[0] + rot * vec4(0,-r,r,1.0);
Normal = vec3(1.0,0,0);
wall = 1;
uv = normalize(vec3(0,-r, r));
_lightDirection = mat3(transpose(rot)) * lightDirection[0];//transpose of rotation matrix is its inverse right?
eye = mat3(transpose(rot)) * ed[0];
EmitVertex();

gl_Position = vertPosition[0] + rot * vec4(0,r, r,1.0);
Normal = vec3(1.0,0,0);
wall = 1;
uv = normalize(vec3(0, r, r));
_lightDirection = mat3(transpose(rot)) * lightDirection[0];//transpose of rotation matrix is its inverse right?
eye = mat3(transpose(rot)) * ed[0];
EmitVertex();

EndPrimitive(); //*/

}

void main() {
    icosa(0.3);
    pappe(0.3);
}
