#ifndef INCLUDED_PROBGROUP_
#define INCLUDED_PROBGROUP_

#include <iosfwd>
#include <vector>
#include <cstdint>

#include "../group/group.h"
#include "../enums/enums.h"
#include "../globals/globals.h"

// This class used to be 'Density', but with the introduction of lung cancer
// simulations cumulative probabilites are also used by 'Survival'. 


// 
// config. params using probabilities:
// BreastDensities:
// 
//     #                bi-rad:  a      b      c      d
//     ageGroup:    0  - 40:    .05    .30    .48    .17

// Table S3 probabilities:
//     prob:   0 - 20:   .8186   .0333     .0832       .0709       // T1a,b

class ProbGroup
{
    friend std::istream &operator>>(std::istream &in, ProbGroup &probgroup);
    friend std::ostream &operator<<(std::ostream &out, 
                                    ProbGroup const &probgroup);
    enum 
    {
        N_PROBCATS = 4,   // # of probability categories
    };

    Group    d_group;

    std::vector<double> d_prob;
    std::vector<double> d_cumProbs;
                                                // false: lung cancer sim., 
    bool d_breastCancer;                        // true: breast cancer sim.
                      
    static char const *s_labels[][2];

    public:
        using Vector = std::vector<ProbGroup>;  // ensure sorted by group-end
                                                // and that the full range is
                                                // covered
        ProbGroup();           

        uint16_t  begin() const;                // was: beginAge        // .f
        uint16_t  end() const;                  // was: endAge          // .f

        Group const &group() const;                                     // .f

//        bool contains(double age) const;        // OBS, use indexOf

        std::vector<double> const &prob() const;    // was: birad       // .f
        double    prob(size_t idx) const;           // was: birad       // .f

        bool sumOne() const;

                                                // returns string::npos if 
                                                // value not in vect.
        static uint16_t probIndexOf(Vector const &vect, 
                                    double value, double prob);
    private:
        bool contains(double value) const;                              // .f

        std::istream &extract(std::istream &in);
        std::ostream &insert(std::ostream &out) const;

                                                // string::npos: 'value' not
                                                // in the ProbGroup's.
        uint16_t indexOf(double value) const;

};

#include "probgroup.f"

#endif


