//--------------------------------------------------------------------------
// Copyright (C) 2015-2024 Cisco and/or its affiliates. All rights reserved.
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License Version 2 as published
// by the Free Software Foundation.  You may not use, modify or distribute
// this program under any other version of the GNU General Public License.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//--------------------------------------------------------------------------

#ifndef IMAP_CONFIG_H
#define IMAP_CONFIG_H

// Configuration for Imap service inspector

#include "mime/file_mime_process.h"

struct IMAP_PROTO_CONF
{
    snort::DecodeConfig decode_conf;
    snort::MailLogConfig log_config;
};

struct ImapStats
{
    PegCount packets;
    PegCount sessions;
    PegCount concurrent_sessions;
    PegCount max_concurrent_sessions;
    PegCount start_tls;
    PegCount ssl_search_abandoned;
    PegCount ssl_srch_abandoned_early;
    snort::MimeStats mime_stats;
    PegCount js_pdf_scripts;
};

extern const PegInfo imap_peg_names[];
extern THREAD_LOCAL ImapStats imapstats;

#endif
