/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.Healpix;
import cds.healpix.common.math.FastMath;
import cds.healpix.common.math.HackersDelight;

final class HealpixProjector {
    private double absLon;
    private long signLon;
    private double absLat;
    private long signLat;
    private int xOffset;
    private double x;
    private double y;

    HealpixProjector() {
    }

    void project(double lon, double lat, double[] resultXY) {
        Healpix.checkLatitude(lat);
        this.computeAbsOfLonLatAndKeepSigns(lon, lat);
        this.scaleAbsLonFromMinus1ToPlus1AndKeepRangeOffset();
        this.reduceRangeOffsetToMax7();
        if (this.isInEquatorialRegion()) {
            this.projectCylindricalEqualArea();
        } else {
            this.projectCollignon();
        }
        this.shiftXByReducedRangeOffset();
        this.applyLonLatSignsToXY();
        this.storeResultIn(resultXY);
    }

    private void computeAbsOfLonLatAndKeepSigns(double lon, double lat) {
        this.computeAbsOfLonAndKeepSign(lon);
        this.computeAbsOfLatAndKeepSign(lat);
    }

    private void computeAbsOfLonAndKeepSign(double lon) {
        this.signLon = HackersDelight.toBits(lon);
        assert (lon == HackersDelight.fromBits(this.signLon)) : lon + " != " + HackersDelight.fromBits(this.signLon);
        this.absLon = HackersDelight.fromBits(this.signLon & Long.MAX_VALUE);
        assert (0.0 <= this.absLon && this.absLon <= 62.83185307179586);
        this.signLon &= Long.MIN_VALUE;
        assert (this.signLon == 0L || this.signLon == Long.MIN_VALUE);
    }

    private void computeAbsOfLatAndKeepSign(double lat) {
        this.signLat = HackersDelight.toBits(lat);
        assert (lat == HackersDelight.fromBits(this.signLat));
        this.absLat = HackersDelight.fromBits(this.signLat & Long.MAX_VALUE);
        assert (0.0 <= this.absLat && this.absLat <= 1.5707963267948966);
        this.signLat &= Long.MIN_VALUE;
        assert (this.signLat == 0L || this.signLat == Long.MIN_VALUE);
    }

    private void scaleAbsLonFromMinus1ToPlus1AndKeepRangeOffset() {
        this.x = 1.2732395447351628 * this.absLon;
        this.xOffset = (int)this.x | 1;
        assert (1 <= this.xOffset && this.xOffset % 2 == 1);
        this.x -= (double)this.xOffset;
        assert (-1.0 <= this.x && this.x <= 1.0);
    }

    private void reduceRangeOffsetToMax7() {
        this.xOffset &= 7;
        assert (1 <= this.xOffset && this.xOffset <= 7 && this.xOffset % 2 == 1);
    }

    private boolean isInEquatorialRegion() {
        return this.absLat <= Healpix.TRANSITION_LATITUDE;
    }

    private void projectCylindricalEqualArea() {
        this.y = FastMath.sinQ(this.absLat, 0.0);
        assert (0.0 <= this.y && this.y <= 0.6666666666666666);
        this.y *= 1.5;
        assert (this.y <= 1.0);
    }

    private void projectCollignon() {
        this.y = Healpix.sqrtOfThreeTimeOneMinusSinOf(this.absLat);
        assert (0.0 <= this.y && this.y < 1.0);
        this.x *= this.y;
        assert (-1.0 <= this.x && this.x <= 1.0);
        this.y = 2.0 - this.y;
        assert (1.0 < this.y && this.y <= 2.0);
    }

    private void shiftXByReducedRangeOffset() {
        this.x += (double)this.xOffset;
        assert (0.0 <= this.x && this.x <= 8.0);
    }

    private void applyLonLatSignsToXY() {
        this.applyLonSignToX();
        this.applyLatSignToY();
    }

    private void applyLonSignToX() {
        this.x = HackersDelight.fromBits(this.signLon | HackersDelight.toBits(this.x));
        assert (-8.0 < this.x && this.x < 8.0);
    }

    private void applyLatSignToY() {
        this.y = HackersDelight.fromBits(this.signLat | HackersDelight.toBits(this.y));
        assert (-2.0 <= this.y && this.y <= 2.0);
    }

    private void storeResultIn(double[] resultXY) {
        resultXY[0] = this.x;
        resultXY[1] = this.y;
    }
}

