#!/bin/sh
#
# This shell script scans the opcodes.h file (which is itself generated by
# another shell script) and uses the information gleaned to create the
# opcodes.c source file.
#
# Opcodes.c contains strings which are the symbolic names for the various
# opcodes used by the VDBE.  These strings are used when disassembling a
# VDBE program during tracing or as a result of the EXPLAIN keyword.

printf '%s\n' "/* Automatically generated.  Do not edit */"
printf '%s\n' "/* See the tool/mkopcodec.sh script for details. */"
printf '%s\n' "#include \"sqlInt.h\""
printf '%s\n' "#if defined(SQL_ENABLE_EXPLAIN_COMMENTS) || defined(SQL_DEBUG)"
printf '%s\n' "# define OpHelp(X) \"\\0\" X"
printf '%s\n' "#else"
printf '%s\n' "# define OpHelp(X)"
printf '%s\n' "#endif"
printf '%s\n' "const char *sqlOpcodeName(int i){"
printf '%s\n' " static const char *const azName[] = {"
mx=0

set -eu  # Strict shell (w/o -x and -o pipefail)
set -f   # disable pathname expansion

newline="$(printf '\n')"
IFS="$newline"
while read line; do
    case "$line" in
    '#define OP_'*)
        IFS=" "
        set -- $line
        IFS="$newline"
        name="${2#OP_}"
        i="$3"
        eval "ARRAY_label_$i=\"$name\""
        if [ "$mx" -lt "$i" ]; then
            mx="$i"
        fi
        case "$line" in
        *'synopsis: '*' */'*)
            x=${line#*'synopsis: '}
            x=${x%' */'*}
            # trim
            while true; do
                case "$x" in
                ' '*) x=${x# } ;;
                *' ') x=${x% } ;;
                *) break ;;
                esac
            done
            eval "ARRAY_synopsis_$i=\"$x\""
            ;;
        *)
            eval "ARRAY_synopsis_$i=\"\""
            ;;
        esac
        ;;
    esac
done < "$1"

i=0
while [ "$i" -le "$mx" ]; do
    eval "label=\"\$ARRAY_label_$i\""
    eval "synopsis=\"\$ARRAY_synopsis_$i\""
    printf '    /* %3d */ %-18s OpHelp("%s"),\n' "$i" "\"$label\"" "$synopsis"
    i=$((i + 1))
done
printf '%s\n' "  };"
printf '%s\n' "  return azName[i];"
printf '%s\n' "}"
