// SPDX-License-Identifier: Apache-2.0
// Copyright Authors of Tetragon
package api

// Msg Flag Definitions
const (
	EventUnknown = 0x00
	// EventExecve indicates the event is generated by an execve*. See
	// EventProcFS for the other option. A correctly formatted event should
	// either set EventExecve or EventProcFS.
	EventExecve = 0x01
	// Deprecated: EventExecveAt indicates the event is generated by an
	// execveAt syscall
	EventExecveAt = 0x02
	// EventProcFS indicates the event is generated from a proc interface.
	// This happens at Tetragon init when existing processes are being loaded
	// into Tetragon event buffer. All events should have either EventExecve or
	// EventProcFS set.
	EventProcFS = 0x04
	// EventTruncFilename indicates we truncated the processes filename
	// because the buffer size is too small. Consider increasing buffer
	// size to avoid this.
	EventTruncFilename = 0x08
	// EventTruncArgs indicates we truncated the processes arguments because
	// the buffer size was too small to fit all exec args. Consider increasing
	// buffer size to avoid this.
	EventTruncArgs = 0x10
	// EventTaskWalk indicates we walked the process hierarchy to find a
	// parent process in the Tetragon buffer. This may happen when we did not
	// receive an exec event for the immediate parent of a process.
	// Typically means we are looking at a fork that in turn did another
	// fork we don't currently track fork events exactly and instead push
	// an event with the original parent exec data. This flag can provide
	// this insight into the event if needed. Primarily useful for debugging.
	EventTaskWalk = 0x20
	// EventMiss is an *error flag* indicating we could not find parent info
	// in the Tetragon event buffer. If this is set it should be reported to Tetragon
	// developers for debugging. Tetragon will do its best to recover information
	// about the process from available kernel data structures instead of
	// using cached info in this case. However, args will not be available.
	EventMiss = 0x40
	// EventNeedsAUID is an *internal flag* for Tetragon to indicate the audit
	// has not yet been resolved. The BPF hooks look at this flag to
	// determine if probing the audit system is necessary.
	EventNeedsAUID = 0x80
	// EventErrorFilename is an *error flag* indicating an error happened
	// while reading the filename. If this is set it should be reported to
	// Tetragon developers for debugging.
	EventErrorFilename = 0x100
	// EventErrorArgs is an *error flag* indicating an error happened while
	// reading the process args. If this is set it should be reported to
	// Tetragon developers for debugging.
	EventErrorArgs = 0x200
	// EventNeedsCWD is an *internal flag* for Tetragon to indicate the current
	// working directory has not yet been resolved. The Tetragon hooks look at
	// this flag to determine if probing the CWD is necessary.
	EventNeedsCWD = 0x400
	// EventNoCWDSupport indicates we removed the CWD from the event because
	// the buffer size is too small. Consider increasing buffer size to avoid
	// this.
	EventNoCWDSupport = 0x800
	// EventRootCWD indicates the CWD is the root directory. This is necessary
	// to inform readers the CWD is not in the event buffer and is '/' instead.
	EventRootCWD = 0x1000
	// EventErrorCWD is an *error flag* indicating an error happened while
	// reading the CWD of a process. If this is set it should be reported to
	// Tetragon developers for debugging.
	EventErrorCWD = 0x2000
	// EventClone indicates the process issues a clone before exec* was
	// issued. This is the general flow to exec* a new process. However,
	// its possible to replace the current process with a new process
	// by doing an exec* without a clone. In this case the flag will
	// be omitted. Also the same PID will be used by the kernel for both
	// the old process and the newly exec'd process.
	EventClone = 0x4000

	// EventCgroup*Err indicate the process cgroup information lookup failed in the
	// kernel. The strings {Name|Kn|SubsysCgrp|Subsys|Cgroup} give us a hint
	// at the specific read that failed so we can investigate the cause.
	// The cgroup name is used to get the container ID or docker field.
	EventErrorCgroupName       = 0x010000
	EventErrorCgroupKn         = 0x020000
	EventErrorCgroupSubsysCgrp = 0x040000
	EventErrorCgroupSubsys     = 0x080000
	EventErrorCgroups          = 0x100000
	EventErrorCgroupId         = 0x200000

	EventErrorPathComponents = 0x400000

	// EventDataFilename indicates filename is received with data event
	EventDataFilename = 0x800000
	// EventDataArgs indicates args are received with data event
	EventDataArgs = 0x1000000
)
