# Go

## Features
Trivy supports two types of Go scanning, Go Modules and binaries built by Go.
The following table provides an outline of the features Trivy offers.

| Artifact | Offline[^1] | Dev dependencies | License | Dependency graph |
|----------|:-----------:|:-----------------|:-------:|:----------------:|
| Modules  |      ✅      | Include          |  ✅[^2]  |      ✅[^2]       |
| Binaries |      ✅      | Exclude          |    -    |        -         |

!!! note
    Trivy scans only dependencies of the Go project.
    Let's say you scan the Docker binary, Trivy doesn't detect vulnerabilities of Docker itself.
    Also, when you scan go.mod in Kubernetes, the Kubernetes vulnerabilities will not be found.

### Go Modules
Depending on Go versions, the required files are different.

| Version | Required files | Offline |
|---------|:--------------:|:-------:|
| \>=1.17 |     go.mod     |    ✅    |
| <1.17   | go.mod, go.sum |    ✅    |

In Go 1.17+ projects, Trivy uses `go.mod` for direct/indirect dependencies.
On the other hand, it uses `go.mod` for direct dependencies and `go.sum` for indirect dependencies in Go 1.16 or less.

Go 1.17+ holds actually needed indirect dependencies in `go.mod`, and it reduces false detection.
`go.sum` in Go 1.16 or less contains all indirect dependencies that are even not needed for compiling.
If you want to have better detection, please consider updating the Go version in your project.

!!! note
    The Go version doesn't mean your CLI version, but the Go version in your go.mod.

    ```
    module github.com/aquasecurity/trivy
    
    go 1.18
    
    require (
            github.com/CycloneDX/cyclonedx-go v0.5.0
            ...
    )
    ```

    To update the Go version in your project, you need to run the following command.

    ```
    $ go mod tidy -go=1.18
    ```

To identify licenses and dependency relationships, you need to download modules to local cache beforehand,
such as `go mod download`, `go mod tidy`, etc.
Trivy traverses `$GOPATH/pkg/mod` and collects those extra information.

### Go binaries
Trivy scans binaries built by Go.
If there is a Go binary in your container image, Trivy automatically finds and scans it.

Also, you can scan your local binaries.

```
$ trivy fs ./your_binary
```

[^1]: It doesn't require the Internet access.
[^2]: Need to download modules to local cache beforehand