/*
 * Decompiled with CFR 0.152.
 */
package org.ccil.cowan.tagsoup;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.ccil.cowan.tagsoup.ElementType;
import org.ccil.cowan.tagsoup.HTMLSchema;
import org.ccil.cowan.tagsoup.PYXScanner;
import org.ccil.cowan.tagsoup.PYXWriter;
import org.ccil.cowan.tagsoup.Parser;
import org.ccil.cowan.tagsoup.XMLWriter;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class CommandLine {
    private static Parser myParser = null;

    public static void main(String[] stringArray) throws IOException, SAXException {
        Object object;
        HTMLSchema hTMLSchema = HTMLSchema.sharedSchema();
        if (Boolean.getBoolean("nocdata")) {
            ElementType elementType = hTMLSchema.getElementType("script");
            elementType.setFlags(0);
            object = hTMLSchema.getElementType("style");
            ((ElementType)object).setFlags(0);
        }
        if (stringArray.length == 0) {
            CommandLine.process("", System.out);
        } else if (Boolean.getBoolean("files")) {
            for (int i = 0; i < stringArray.length; ++i) {
                object = stringArray[i];
                int n = ((String)object).lastIndexOf(46);
                String string = n == -1 ? (String)object + ".xhtml" : (((String)object).endsWith(".xhtml") ? (String)object + "_" : ((String)object).substring(0, n) + ".xhtml");
                System.err.println("src: " + (String)object + " dst: " + string);
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                CommandLine.process((String)object, fileOutputStream);
            }
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                System.err.println("src: " + stringArray[i]);
                CommandLine.process(stringArray[i], System.out);
            }
        }
    }

    private static void process(String string, OutputStream outputStream) throws IOException, SAXException {
        Parser parser;
        if (Boolean.getBoolean("reuse")) {
            if (myParser == null) {
                myParser = new Parser();
            }
            parser = myParser;
        } else {
            parser = new Parser();
        }
        if (Boolean.getBoolean("nons")) {
            parser.setFeature("http://xml.org/sax/features/namespaces", false);
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        if (Boolean.getBoolean("nobogons")) {
            parser.setFeature("http://www.ccil.org/~cowan/tagsoup/features/ignore-bogons", true);
        }
        if (Boolean.getBoolean("any")) {
            parser.setFeature("http://www.ccil.org/~cowan/tagsoup/features/bogons-empty", false);
        }
        if (Boolean.getBoolean("pyxin")) {
            parser.setProperty("http://www.ccil.org/~cowan/tagsoup/properties/scanner", new PYXScanner());
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        ContentHandler contentHandler = CommandLine.chooseContentHandler(outputStreamWriter);
        parser.setContentHandler(contentHandler);
        if (Boolean.getBoolean("lexical") && contentHandler instanceof LexicalHandler) {
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", contentHandler);
        }
        if (string != "") {
            parser.parse(string);
        } else {
            parser.parse(new InputSource(System.in));
        }
    }

    private static ContentHandler chooseContentHandler(Writer writer) {
        ContentHandler contentHandler;
        if (Boolean.getBoolean("pyx")) {
            contentHandler = new PYXWriter(writer);
        } else if (Boolean.getBoolean("html")) {
            XMLWriter xMLWriter = new XMLWriter(writer);
            xMLWriter.setHTMLMode(true);
            contentHandler = xMLWriter;
        } else {
            contentHandler = new XMLWriter(writer);
        }
        return contentHandler;
    }
}

