/***********************************************************************
 *
 * $CVSHeader$
 *
 * This file is part of WebScarab, an Open Web Application Security
 * Project utility. For details, please see http://www.owasp.org/
 *
 * Copyright (c) 2002 - 2004 Rogan Dawes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Getting Source
 * ==============
 *
 * Source for this application is maintained at Sourceforge.net, a
 * repository for free software projects.
 * 
 * For details, please see http://www.sourceforge.net/projects/owasp
 *
 */

/*
 * FragmentsFrame.java
 *
 * Created on December 18, 2003, 3:22 PM
 */

package org.owasp.webscarab.plugin.fragments.swing;

import javax.swing.table.AbstractTableModel;

import org.owasp.webscarab.util.swing.MultiLineCellRenderer;

/**
 *
 * @author  rdawes
 */
public class FragmentsFrame extends javax.swing.JFrame {
    
    /**
	 * 
	 */
	private static final long serialVersionUID = 7945448210186454157L;
	private FragmentTableModel _ftm;
    
    /** Creates new form FragmentsFrame */
    public FragmentsFrame() {
        _ftm = new FragmentTableModel();
        initComponents();
        fragmentTable.setModel(_ftm);
        fragmentTable.setDefaultRenderer(String.class, new MultiLineCellRenderer());
    }
    
    public void setFragments(String[] fragments) {
        _ftm.setFragments(fragments);
        fragmentTable.getColumnModel().getColumn(0).setPreferredWidth(640);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jScrollPane1 = new javax.swing.JScrollPane();
        fragmentTable = new javax.swing.JTable();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setTitle("Fragment Frame");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        fragmentTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        fragmentTable.setAutoResizeMode(javax.swing.JTable.AUTO_RESIZE_OFF);
        jScrollPane1.setViewportView(fragmentTable);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        getContentPane().add(jScrollPane1, gridBagConstraints);

        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setBounds((screenSize.width-640)/2, (screenSize.height-480)/2, 640, 480);
    }//GEN-END:initComponents
    
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        this.dispose();
    }//GEN-LAST:event_exitForm
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        FragmentsFrame ff = new FragmentsFrame();
        ff.setFragments(new String[] { "a\nb\ncdef\n", "abc def ghi jkl mno pqr stu vwx yz\nabc def ghi jkl mno pqr stu vwx yz\nabc def ghi jkl mno pqr stu vwx yz\nabc def ghi jkl mno pqr stu vwx yz\nabc def ghi jkl mno pqr stu vwx yz\nabc def ghi jkl mno pqr stu vwx yz\nabc def ghi jkl mno pqr stu vwx yz\nabc def ghi jkl mno pqr stu vwx yz\nabc def ghi jkl mno pqr stu vwx yz\nabc def ghi jkl mno pqr stu vwx yz\nabc def ghi jkl mno pqr stu vwx yz\nabc def ghi jkl mno pqr stu vwx yz\nabc def ghi jkl mno pqr stu vwx yz\nabc def ghi jkl mno pqr stu vwx yz\nabc def ghi jkl mno pqr stu vwx yz\nabc def ghi jkl mno pqr stu vwx yz\n", 
        "0123456789 0123456789 0123456789 0123456789 0123456789 0123456789 0123456789 0123456789 "});
        ff.setVisible(true);
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTable fragmentTable;
    private javax.swing.JScrollPane jScrollPane1;
    // End of variables declaration//GEN-END:variables
    
    
    private class FragmentTableModel extends AbstractTableModel {
        
        /**
		 * 
		 */
		private static final long serialVersionUID = -4290112756620953610L;
		private String[] _fragments = null;
        
        public FragmentTableModel() {
        }
        
        public void setFragments(String[] fragments) {
            _fragments = fragments;
            fireTableDataChanged();
        }
        
        public int getColumnCount() {
            return 1;
        }
        
        public Class<String> getColumnClass(int columnIndex) {
            return String.class;
        }
        
        public int getRowCount() {
            if (_fragments == null) {
                return 0;
            } else {
                return _fragments.length;
            }
        }
        
        public Object getValueAt(int rowIndex, int columnIndex) {
            return _fragments[rowIndex];
        }
        
    }
    
}
