/***********************************************************************
 *
 * $CVSHeader$
 *
 * This file is part of WebScarab, an Open Web Application Security
 * Project utility. For details, please see http://www.owasp.org/
 *
 * Copyright (c) 2002 - 2004 Rogan Dawes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Getting Source
 * ==============
 *
 * Source for this application is maintained at Sourceforge.net, a
 * repository for free software projects.
 *
 * For details, please see http://www.sourceforge.net/projects/owasp
 *
 */

/*
 * MessagePanel.java
 *
 * Created on November 6, 2003, 8:43 AM
 */

package org.owasp.webscarab.ui.swing;

import org.owasp.webscarab.model.Preferences;
import org.owasp.webscarab.model.Message;
import org.owasp.webscarab.model.NamedValue;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;

/**
 *
 * @author  rdawes
 */
public class MessagePanel extends javax.swing.JPanel {
    
    /**
	 * 
	 */
	private static final long serialVersionUID = -295413596776666722L;
	private ContentPanel _cp;
    private HeaderPanel _hp;
    private Message _message = null;
    private boolean _editable = false;
    
    /** Creates new form MessagePanel */
    public MessagePanel() {
        initComponents();
        setName("Message");
        
        _hp = new HeaderPanel();
        messageSplitPane.setTopComponent(_hp);
        _cp = new ContentPanel();
        messageSplitPane.setBottomComponent(_cp);
        String dividerLocation = Preferences.getPreference("MessagePanel.dividerLocation");
        if (dividerLocation != null) {
            try {
                messageSplitPane.setDividerLocation(Integer.parseInt(dividerLocation));
            } catch (NumberFormatException nfe) {}
        }
        messageSplitPane.addPropertyChangeListener(new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("dividerLocation")) {
                    Preferences.setPreference("MessagePanel.dividerLocation", e.getNewValue().toString());
                }
            }
        });
        setEditable(false);
        setMessage(null);
    }
    
    public MessagePanel(int orientation) {
        this();
        messageSplitPane.setOrientation(orientation);
    }
    
    public void setEditable(boolean editable) {
        _editable = editable;
        _hp.setEditable(editable);
        _cp.setEditable(editable);
    }
    
    public void setMessage(Message message) {
        _message = message;
        
        if (message != null) {
            _hp.setHeaders(_message.getHeaders());
            byte[] content = message.getContent();
            _cp.setContentType(message.getHeader("Content-Type"));
            _cp.setContent(content);
        } else {
            _hp.setHeaders(null);
            _cp.setContentType(null);
            _cp.setContent(null);
        }
        revalidate();
    }
    
    public Message getMessage() {
        if (_editable) {
            if (_hp.isModified() && _message != null) {
                _message.setHeaders(_hp.getHeaders());
            }
            if (_cp.isModified()) {
                _message.setContent(_cp.getContent());
                if (_message.getHeader("Content-Length") != null) {
                    _message.setHeader(new NamedValue("Content-Length", Integer.toString(_message.getContent().length)));
                }
            }
        }
        return _message;
    }
    
    public boolean isModified() {
        return _editable && (_hp.isModified() || _cp.isModified());
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        messageSplitPane = new javax.swing.JSplitPane();

        setLayout(new java.awt.BorderLayout());

        setPreferredSize(new java.awt.Dimension(400, 200));
        messageSplitPane.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);
        messageSplitPane.setResizeWeight(0.3);
        messageSplitPane.setContinuousLayout(true);
        messageSplitPane.setDoubleBuffered(true);
        messageSplitPane.setOneTouchExpandable(true);
        add(messageSplitPane, java.awt.BorderLayout.CENTER);

    }//GEN-END:initComponents
            
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JSplitPane messageSplitPane;
    // End of variables declaration//GEN-END:variables
    
}
