#include "udposix.h"
#include <stdio.h>
#include "xgks.h"

#define WSID_X11	1
#define WSID_MO		2
#define WSID_WISS	3
#define TRANS_ID	1


    static void
openplot() 
{
     Glimit	window;

    /*
     * Open the GKS plot package.
     * Opens X11 workstation (iwk=#1) and/or metafile (iwk=#2) for plotting.
     * Sets transformation #1 from Plot-Board (PB) WCs (inches) to NDCs.
     */

    /* Open GKS */
    (void) gopengks(stderr, (long)0);

    /* Make whole X11 gks-window the workstation window. */
    window.xmin = 0;
    window.xmax = 1;
    window.ymin = 0;
    window.ymax = .8;

    /* Open and activate metafile "workstation". */
    (void) gopenws(WSID_MO, "meta1.gks", "MO");
    (void) gactivatews(WSID_MO);
    (void) gsetwswindow(WSID_MO, &window);

    /* Open and activate WISS "workstation". */
    (void) gopenws(WSID_WISS, (char*)NULL, "WISS");
    (void) gactivatews(WSID_WISS);

    /* Open and activate X11 workstation. */
    (void) gopenws(WSID_X11, (char*)NULL, (char*)NULL);
    (void) gactivatews(WSID_X11);
    (void) gsetwswindow(WSID_X11, &window);

    /*
     * Define a Plot-Board-World-Coord (PBWC) system in inches
     * with bounds based on NDC window shape.
     * (WCs will be 10 times larger than NDC's)
     */
    (void) gsetviewport(TRANS_ID, &window);
    window.xmin *= 10;
    window.xmax *= 10;
    window.ymin *= 10;
    window.ymax *= 10;
    (void) gsetwindow(TRANS_ID, &window);

    (void) gselntran(TRANS_ID);
}


    static void
setclrmap(ncolors, red, grn, blu)
    int		ncolors;
    int		*red, *grn, *blu;
{
    int		i;

    /* Set color map. */
    for (i = 0; i < ncolors; ++i) {
	Gcobundl        rep;

	rep.red		= red[i]/255.0;
	rep.green	= grn[i]/255.0;
	rep.blue	= blu[i]/255.0;
	(void) gsetcolourrep(WSID_X11, i, &rep);
	(void) gsetcolourrep(WSID_MO, i, &rep);
    }
}


    static void
closeplot()
{
    /* Close the X11 workstation. */
    (void) gdeactivatews(WSID_X11);
    (void) gclosews(WSID_X11);

    /* Close the meta-workstation. */
    (void) gdeactivatews(WSID_MO);
    (void) gclosews(WSID_MO);

    /* Close the WISS workstation. */
    (void) gdeactivatews(WSID_WISS);
    (void) gclosews(WSID_WISS);

    /* Close GKS. */
    (void) gclosegks();
}


    static
WaitForBreak(wsid)
    Gint            wsid;
{
    Gchoice         init;
    Gchoicerec      record;
    Glimit          earea;

    earea.xmin = 0.0;
    earea.xmax = 1279.0;
    earea.ymin = 0.0;
    earea.ymax = 1023.0;

    init.status = GC_NOCHOICE;
    init.choice = 0;
    record.pet1.data = NULL;
    ginitchoice(wsid, 1, &init, 1, &earea, &record);
    gsetchoicemode(wsid, 1, GREQUEST, GECHO);
    for (; init.status != GC_NONE;)
	greqchoice(wsid, 1, &init);
}


main()
{
    int		ired[256], igrn[256], iblu[256];
    int		ncolors;
    int		i;

    /* Set color map. */
    (void) printf("Give ncolors (try 16 and 17, for example): ");
    (void) scanf("%d", &ncolors);
    (void) putchar('\n');

    /*Open plot. */
    openplot();

    ired[0] = 255;
    igrn[0] = 255;
    iblu[0] = 255;

    for (i = 1; i < ncolors; ++i) {
        ired[i] = 0;
        igrn[i] = 0;
        iblu[i] = 0;
    }
    setclrmap(ncolors, ired, igrn, iblu);

    /* Plot  polyline. */
    for (i = 0; i < 40; ++i) {
	Gpoint	pts[2];

	(void) fprintf(stderr, "Plotting polyline %d\n", i);

        pts[0].x	= 1.0 + (i+1)*0.1;
        pts[0].y	= 1.0;
        pts[1].x	= pts[0].x;
        pts[1].y	= pts[0].y + 1.0;

	(void) gpolyline(2, pts);
    }

    /* Finish plotting. */
    WaitForBreak(WSID_X11);
    closeplot();
}
