/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.util.EnumMap;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.text.StyleContext;

public class FontUtils {
    private static float scale = -1.0f;
    private static EnumMap<FontType, Font> defaultFonts = new EnumMap(FontType.class);
    private static EnumMap<FontType, Boolean> defaultFontSets = new EnumMap(FontType.class);
    private static Font systemDefaultFont;
    private static Font quicksandBoldFont;

    public static Font getSystemDefaultFont() {
        if (systemDefaultFont == null && (systemDefaultFont = (Font)UIManager.getLookAndFeelDefaults().get("defaultFont")) == null) {
            systemDefaultFont = new JLabel("").getFont();
        }
        return systemDefaultFont;
    }

    public static Font getQuicksandBoldFont() {
        if (quicksandBoldFont == null) {
            try {
                quicksandBoldFont = Font.createFont(0, FontUtils.class.getResourceAsStream("/resource/Quicksand-Bold.ttf"));
                GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(quicksandBoldFont);
                quicksandBoldFont = quicksandBoldFont.deriveFont((float)FontUtils.getDefaultFont().getSize());
            }
            catch (FontFormatException | IOException e) {
                quicksandBoldFont = defaultFonts.get((Object)FontType.general);
            }
        }
        return quicksandBoldFont;
    }

    public static boolean canChangeSize() {
        return UIManager.getLookAndFeelDefaults().get("defaultFont") != null;
    }

    public static void setDefaultFont(FontType fontType, Font font) {
        if (FontUtils.canChangeSize()) {
            FontUtils.getSystemDefaultFont();
            defaultFonts.put(fontType, font);
            scale = -1.0f;
            if (fontType == FontType.general) {
                UIManager.getLookAndFeelDefaults().put("defaultFont", font);
            }
        }
    }

    public static void setDefaultFont(FontType fontType, String name, int size) {
        if (size <= 5) {
            size = FontUtils.getDefaultFont().getSize();
        }
        defaultFontSets.put(fontType, name != null && !name.isEmpty());
        FontUtils.setDefaultFont(fontType, FontUtils.getFont(name, 0, size));
    }

    private static Font getDefaultFont() {
        return FontUtils.getDefaultFont(FontType.general);
    }

    private static Font getDefaultFont(FontType fontType) {
        if (defaultFonts.get((Object)fontType) == null) {
            defaultFonts.put(fontType, Font.getFont("defaultFont"));
            if (defaultFonts.get((Object)fontType) == null) {
                defaultFonts.put(fontType, new JLabel("").getFont());
            }
        }
        return defaultFonts.get((Object)fontType);
    }

    public static Font getFont(String name) {
        return FontUtils.getFont(name, 0);
    }

    public static Font getFont(int style) {
        return FontUtils.getDefaultFont().deriveFont(style);
    }

    public static Font getFont(FontType fontType) {
        return FontUtils.getDefaultFont(fontType);
    }

    public static Font getFontWithFallback(FontType fontType, String fallbackFontName) {
        if (FontUtils.isDefaultFontSet(fontType)) {
            return FontUtils.getFont(fontType);
        }
        return FontUtils.getFont(fallbackFontName);
    }

    public static Font getFont(String name, int style) {
        return FontUtils.getFont(name, style, FontUtils.getDefaultFont().getSize());
    }

    public static Font getFont(int style, Size size) {
        return FontUtils.getFont(FontUtils.getDefaultFont(), size).deriveFont(style);
    }

    public static Font getFont(Font font, int style, Size size) {
        return FontUtils.getFont(font, size).deriveFont(style);
    }

    public static Font getFont(Size size) {
        return FontUtils.getFont(FontUtils.getDefaultFont(), size);
    }

    public static Font getFont(Font font, Size size) {
        float s;
        switch (size) {
            case smallest: {
                s = (float)((double)font.getSize() * 0.5);
                break;
            }
            case much_smaller: {
                s = (float)((double)font.getSize() * 0.7);
                break;
            }
            case smaller: {
                s = (float)((double)font.getSize() * 0.8);
                break;
            }
            case standard: {
                s = font.getSize();
                break;
            }
            case larger: {
                s = (float)((double)font.getSize() * 1.5);
                break;
            }
            case much_larger: {
                s = font.getSize() * 3;
                break;
            }
            case huge: {
                s = font.getSize() * 4;
                break;
            }
            default: {
                s = font.getSize();
            }
        }
        return font.deriveFont(s);
    }

    public static Font getFont(String name, int style, int size) {
        return StyleContext.getDefaultStyleContext().getFont(name, style, size);
    }

    public static float getScale() {
        if (scale == -1.0f) {
            scale = FontUtils.getDefaultFont().getSize2D() / FontUtils.getSystemDefaultFont().getSize2D();
        }
        return scale;
    }

    public static boolean isDefaultFontSet() {
        return defaultFontSets.get((Object)FontType.general);
    }

    public static boolean isDefaultFontSet(FontType fontType) {
        return defaultFontSets.get((Object)fontType);
    }

    public static enum FontType {
        general,
        workPanels;

    }

    public static enum Size {
        smallest,
        much_smaller,
        smaller,
        standard,
        larger,
        much_larger,
        huge;

    }
}

