/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.certificates.ui.manager;

import com.paterva.maltego.certificates.ui.manager.CertificateNode;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;

public class ExpiresDateTableCellRenderer
extends DefaultTableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        String valueString = null;
        if (value != null && value instanceof CertificateNode.Expires) {
            try {
                UIDefaults laf = UIManager.getLookAndFeelDefaults();
                CertificateNode.Expires expire = (CertificateNode.Expires)((Object)value);
                valueString = expire.getValue();
                SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM y 'at' h:mm:ss a z");
                Date expiryDate = sdf.parse(valueString);
                Date now = new Date();
                Calendar monthFomNow = Calendar.getInstance();
                monthFomNow.setTime(now);
                monthFomNow.add(2, 1);
                if (monthFomNow.getTime().before(expiryDate)) {
                    c.setForeground(laf.getColor("darcula.inactiveForeground"));
                } else if (now.before(expiryDate)) {
                    if (isSelected) {
                        c.setForeground(table.getSelectionForeground());
                    } else {
                        c.setForeground(table.getSelectionBackground());
                    }
                } else {
                    c.setForeground(laf.getColor("7-dark-red"));
                }
            }
            catch (IllegalAccessException | InvocationTargetException | ParseException exception) {
                // empty catch block
            }
        }
        this.setText(valueString == null ? "" : valueString);
        return c;
    }
}

