/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.detailview.html;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphEntity;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.GraphLink;
import com.paterva.maltego.core.GraphPart;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.PropertyBag;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.imgfactory.parts.PartImageHelper;
import com.paterva.maltego.imgfactoryapi.ImageFactory;
import com.paterva.maltego.typing.editing.AttachmentUtils;
import com.paterva.maltego.typing.types.Attachment;
import com.paterva.maltego.ui.graph.view2d.PinUtils;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ImageCallback;
import com.paterva.maltego.util.ui.GraphicsUtils;
import java.awt.Component;
import java.awt.Image;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.jdesktop.swingx.icon.EmptyIcon;
import org.lobobrowser.html.HtmlObject;
import org.openide.util.Exceptions;

class HtmlObjectFactory {
    HtmlObjectFactory() {
    }

    public static HtmlObject createEntityImage(GraphEntity part) {
        if (part != null) {
            return new EntityImageHtmlObject(part);
        }
        return null;
    }

    public static HtmlObject createEntityPinOverlayImage(GraphEntity part, String classID) {
        if (part != null) {
            return new EntityPinOverlayImageHtmlObject(part, classID);
        }
        return null;
    }

    public static HtmlObject createLinkImage(GraphLink part) {
        if (part != null) {
            return new LinkImageHtmlObject(part);
        }
        return null;
    }

    public static HtmlObject createPhotoImage(int attId, GraphPart part) {
        if (part != null) {
            return new PhotoHtmlObject(attId, part);
        }
        return null;
    }

    private static class PhotoHtmlObject
    implements HtmlObject {
        private JLabel _label = new JLabel();

        public PhotoHtmlObject() {
        }

        public PhotoHtmlObject(int attId, GraphPart part) {
            this.setPart(attId, part);
        }

        public Component getComponent() {
            return this._label;
        }

        public void suspend() {
        }

        public void resume() {
        }

        public void destroy() {
        }

        public void reset(int width, int height) {
        }

        private void setPart(int attId, GraphPart part) {
            if (part != null) {
                List atts = AttachmentUtils.getImageAttachments((PropertyBag)GraphStoreHelper.getPart((GraphPart)part));
                for (Attachment att : atts) {
                    if (att.getId() != attId) continue;
                    ImageIcon imageIcon = ImageFactory.getDefault().getImageIcon((Object)att, -1, IconSize.MEDIUM.getSize());
                    if (imageIcon != null) {
                        this._label.setIcon(imageIcon);
                    }
                    break;
                }
            } else {
                this._label.setIcon(null);
            }
        }
    }

    private static class LinkImageHtmlObject
    implements HtmlObject,
    ImageCallback {
        private JLabel _label = new JLabel();

        public LinkImageHtmlObject() {
        }

        public LinkImageHtmlObject(GraphLink graphLink) {
            try {
                this.setLink(graphLink);
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public Component getComponent() {
            return this._label;
        }

        public void suspend() {
        }

        public void resume() {
        }

        public void destroy() {
        }

        public void reset(int width, int height) {
        }

        private void setLink(GraphLink graphLink) throws GraphStoreException {
            GraphID graphID = graphLink.getGraphID();
            LinkID linkID = (LinkID)graphLink.getID();
            this._label.setIcon(PartImageHelper.getIcon((GraphID)graphID, (LinkID)linkID, (int)48));
        }

        public void imageReady(Image image) {
            this._label.setIcon(this.toIcon(image));
        }
    }

    private static class EntityPinOverlayImageHtmlObject
    implements HtmlObject,
    ImageCallback {
        private JLabel _label = new JLabel();

        public EntityPinOverlayImageHtmlObject() {
        }

        public EntityPinOverlayImageHtmlObject(GraphEntity part, String classID) {
            try {
                this.setEntity(part, classID);
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public Component getComponent() {
            return this._label;
        }

        public void suspend() {
        }

        public void resume() {
        }

        public void destroy() {
        }

        public void reset(int width, int height) {
        }

        private void setEntity(GraphEntity graphEntity, String classID) throws GraphStoreException {
            Object icon = null;
            if (graphEntity != null) {
                GraphID graphID = graphEntity.getGraphID();
                EntityID entityID = (EntityID)graphEntity.getID();
                int iconSize = IconSize.TINY.getSize();
                GraphWrapper wrapper = MaltegoGraphManager.getWrapper((GraphID)graphID);
                switch (classID) {
                    case "maltego.entity.pin.overlay.image": {
                        if (wrapper.isCollectionNode(entityID)) {
                            icon = new EmptyIcon(iconSize, iconSize);
                            break;
                        }
                        icon = GraphicsUtils.getPinIcon((int)iconSize, (boolean)PinUtils.isPinned((GraphID)graphID, (EntityID)entityID), (boolean)false, (boolean)false);
                        break;
                    }
                    case "maltego.entity.collection.pin.overlay.image": {
                        iconSize = 20;
                        if (wrapper.isCollectionNode(entityID)) {
                            icon = GraphicsUtils.getPinIcon((int)iconSize, (boolean)PinUtils.isPinned((GraphID)graphID, (EntityID)entityID), (boolean)false, (boolean)false);
                            break;
                        }
                        icon = new EmptyIcon(iconSize, iconSize);
                        break;
                    }
                    default: {
                        icon = new EmptyIcon(iconSize, iconSize);
                    }
                }
            }
            this._label.setIcon((Icon)icon);
        }

        public void imageReady(Image image) {
            this._label.setIcon(this.toIcon(image));
        }
    }

    private static class EntityImageHtmlObject
    implements HtmlObject,
    ImageCallback {
        private JLabel _label = new JLabel();

        public EntityImageHtmlObject() {
        }

        public EntityImageHtmlObject(GraphEntity part) {
            try {
                this.setEntity(part);
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public Component getComponent() {
            return this._label;
        }

        public void suspend() {
        }

        public void resume() {
        }

        public void destroy() {
        }

        public void reset(int width, int height) {
        }

        private void setEntity(GraphEntity graphEntity) throws GraphStoreException {
            Icon icon = null;
            if (graphEntity != null) {
                GraphID graphID = graphEntity.getGraphID();
                EntityID entityID = (EntityID)graphEntity.getID();
                icon = PartImageHelper.getLargeIcon((GraphID)graphID, (EntityID)entityID, (ImageCallback)this);
            }
            this._label.setIcon(icon);
        }

        public void imageReady(Image image) {
            this._label.setIcon(this.toIcon(image));
        }
    }
}

