/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.xsocket.IntrospectionBasedDynamicMBean;
import org.xsocket.connection.IIoDispatcherPoolListener;
import org.xsocket.connection.IoSocketDispatcher;
import org.xsocket.connection.IoSocketDispatcherPool;

final class DispatcherPoolMBeanProxyFactory {
    private static final Logger LOG = Logger.getLogger(DispatcherPoolMBeanProxyFactory.class.getName());

    DispatcherPoolMBeanProxyFactory() {
    }

    public static ObjectName createAndRegister(IoSocketDispatcherPool dispatcherPool, String domain, MBeanServer mbeanServer) throws JMException {
        DispatcherPoolListener dispatcherPoolListener = new DispatcherPoolListener(domain, mbeanServer);
        dispatcherPool.addListener(dispatcherPoolListener);
        for (IoSocketDispatcher dispatcher : dispatcherPool.getDispatchers()) {
            dispatcherPoolListener.onDispatcherAdded(dispatcher);
        }
        return null;
    }

    private static final class DispatcherPoolListener
    implements IIoDispatcherPoolListener {
        private final String domain;
        private final MBeanServer mbeanServer;

        DispatcherPoolListener(String domain, MBeanServer mbeanServer) {
            this.domain = domain;
            this.mbeanServer = mbeanServer;
        }

        public void onDispatcherAdded(IoSocketDispatcher dispatcher) {
            block3: {
                try {
                    ObjectName objectName = new ObjectName(this.domain + ":type=xDispatcher,name=" + dispatcher.getName());
                    this.mbeanServer.registerMBean(new IntrospectionBasedDynamicMBean(dispatcher), objectName);
                }
                catch (InstanceAlreadyExistsException ignore) {
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block3;
                    LOG.warning("error occured by adding mbean for new dispatcher: " + e.toString());
                }
            }
        }

        public void onDispatcherRemoved(IoSocketDispatcher dispatcher) {
            block2: {
                try {
                    ObjectName objectName = new ObjectName(this.domain + ":type=xDispatcher,name=" + dispatcher.getName());
                    this.mbeanServer.unregisterMBean(objectName);
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.warning("error occured by removing mbean of dispatcher: " + e.toString());
                }
            }
        }
    }
}

