/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.util;

import com.oracle.truffle.regex.RegexSyntaxException;
import com.oracle.truffle.regex.UnsupportedRegexException;
import java.util.function.Supplier;

public final class CompilationResult<T> {
    private final T compiledRegex;
    private final RegexSyntaxException syntaxException;
    private final UnsupportedRegexException unsupportedRegexException;

    private CompilationResult(T compiledRegexObject) {
        this.compiledRegex = compiledRegexObject;
        this.syntaxException = null;
        this.unsupportedRegexException = null;
    }

    private CompilationResult(RegexSyntaxException syntaxException) {
        this.compiledRegex = null;
        this.syntaxException = syntaxException;
        this.unsupportedRegexException = null;
    }

    private CompilationResult(UnsupportedRegexException unsupportedRegexException) {
        this.compiledRegex = null;
        this.syntaxException = null;
        this.unsupportedRegexException = unsupportedRegexException;
    }

    public static <T> CompilationResult<T> pack(Supplier<T> compilationTask) {
        try {
            T result = compilationTask.get();
            return new CompilationResult<T>(result);
        }
        catch (RegexSyntaxException e) {
            return new CompilationResult<T>(e);
        }
        catch (UnsupportedRegexException e) {
            return new CompilationResult<T>(e);
        }
    }

    public T unpack() throws RegexSyntaxException, UnsupportedRegexException {
        if (this.compiledRegex != null) {
            assert (this.syntaxException == null);
            assert (this.unsupportedRegexException == null);
            return this.compiledRegex;
        }
        if (this.syntaxException != null) {
            assert (this.compiledRegex == null);
            assert (this.unsupportedRegexException == null);
            throw this.syntaxException;
        }
        assert (this.compiledRegex == null);
        assert (this.syntaxException == null);
        assert (this.unsupportedRegexException != null);
        throw this.unsupportedRegexException;
    }
}

