/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.repository;

import com.paterva.maltego.util.repository.ObservableRepository;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public abstract class FilesystemRepository<T>
extends ObservableRepository<T> {
    private static final Logger LOG = Logger.getLogger(FilesystemRepository.class.getName());
    private static final String NAME_ATTR = "name";
    private final String folderPath;
    private final String extension;
    private final Map<String, T> items = new HashMap<String, T>();

    public FilesystemRepository(String folderPath, String extension) {
        this.checkNonNull("folderPath", folderPath);
        this.checkNonNull("extension", extension);
        this.folderPath = folderPath;
        this.extension = extension.toLowerCase();
        this.load();
    }

    protected abstract T load(FileObject var1) throws Exception;

    protected abstract void save(T var1, FileObject var2) throws Exception;

    public String getFolderPath() {
        return this.folderPath;
    }

    public String getExtension() {
        return this.extension;
    }

    @Override
    public synchronized List<T> getAll() {
        return new ArrayList<T>(this.items.values());
    }

    @Override
    public synchronized Optional<T> get(String itemName) {
        return Optional.ofNullable(this.items.get(itemName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(T item) {
        this.checkNonNull("item", item);
        boolean added = false;
        FilesystemRepository filesystemRepository = this;
        synchronized (filesystemRepository) {
            if (this.items.keySet().stream().anyMatch(name -> name.equals(item))) {
                throw new IllegalArgumentException("Item with name already exists: " + this.getName(item));
            }
            added = this.addItem(item);
        }
        if (added) {
            this.fireItemAdded(item);
        }
    }

    protected boolean addItem(T item) {
        AtomicBoolean added = new AtomicBoolean(false);
        this.getOrCreateFolder().ifPresent(folder -> this.createUniqueFile((FileObject)folder, item).ifPresent(file -> {
            try {
                this.saveItem(item, (FileObject)file);
                added.set(true);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)ex, (String)("Failed to save item: " + this.getName(item))));
            }
        }));
        return added.get();
    }

    protected void saveItem(T item, FileObject file) throws Exception {
        String itemName = this.getName(item);
        this.save(item, file);
        file.setAttribute(NAME_ATTR, (Object)itemName);
        this.items.put(itemName, item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(T item) {
        this.checkNonNull("item", item);
        boolean updated = false;
        FilesystemRepository filesystemRepository = this;
        synchronized (filesystemRepository) {
            String itemName = this.getName(item);
            T cachedItem = this.items.get(itemName);
            Optional<FileObject> fileOpt = this.getFile(itemName);
            if (cachedItem == null) {
                LOG.log(Level.SEVERE, "Item does not exist to update (but file does), will be added: item={0}, file={1}", new Object[]{itemName, fileOpt.get().getPath()});
            }
            if (!fileOpt.isPresent()) {
                LOG.log(Level.SEVERE, "File does not exist for item to update, will be created: {0}", itemName);
                updated = this.addItem(item);
            } else {
                FileObject file = fileOpt.get();
                try {
                    this.saveItem(item, file);
                    updated = true;
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)ex, (String)("Failed to update item: " + itemName)));
                }
            }
        }
        if (updated) {
            this.fireItemChanged(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(T item) {
        this.checkNonNull("item", item);
        Object removedItem = null;
        FilesystemRepository filesystemRepository = this;
        synchronized (filesystemRepository) {
            String itemName = this.getName(item);
            T cachedItem = this.items.get(itemName);
            Optional<FileObject> fileOpt = this.getFile(itemName);
            if (cachedItem == null && !fileOpt.isPresent()) {
                LOG.log(Level.SEVERE, "Repository does not contain item to remove: {0}", itemName);
            } else if (cachedItem == null) {
                LOG.log(Level.SEVERE, "Item does not exist to remove (but file does): item={0}, file={1}", new Object[]{itemName, fileOpt.get().getPath()});
            } else if (!fileOpt.isPresent()) {
                LOG.log(Level.SEVERE, "File does not exist for item to remove: {0}", itemName);
            }
            if (fileOpt.isPresent()) {
                FileObject file = fileOpt.get();
                try {
                    file.delete();
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)ex, (String)("Failed to delete file: " + file.getPath())));
                }
            }
            if (cachedItem != null) {
                removedItem = this.items.remove(itemName);
            }
        }
        if (removedItem != null) {
            this.fireItemRemoved(removedItem);
        }
    }

    protected void load() {
        this.items.clear();
        this.getFiles().forEach(file -> {
            try {
                T item = this.load((FileObject)file);
                this.items.put(this.getName(item), item);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)ex, (String)("Failed to load item: " + file.getPath())));
            }
        });
    }

    private List<FileObject> getFiles() {
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        this.getOrCreateFolder().ifPresent(folder -> {
            for (FileObject file : folder.getChildren()) {
                if (!file.hasExt(this.extension)) continue;
                files.add(file);
            }
        });
        return files;
    }

    private Optional<FileObject> getFile(String itemName) {
        return this.getFiles().stream().filter(file -> itemName.equals(file.getAttribute(NAME_ATTR))).findFirst();
    }

    private Optional<FileObject> getOrCreateFolder() {
        FileObject folder = null;
        try {
            folder = this.getOrCreateFolder(this.folderPath);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)ex, (String)("Failed to get or create repository folder: " + this.folderPath)));
        }
        return Optional.ofNullable(folder);
    }

    private FileObject getOrCreateFolder(String folder) throws IOException {
        return FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)folder);
    }

    private Optional<FileObject> createUniqueFile(FileObject folder, T item) {
        FileObject file = null;
        String name = this.getName(item).toLowerCase().replace(' ', '_').replaceAll("[^\\w]", "");
        String filename = FileUtil.findFreeFileName((FileObject)folder, (String)name, (String)this.extension);
        try {
            file = FileUtil.createData((FileObject)folder, (String)(filename + "." + this.extension));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)ex, (String)("Failed to create file: " + filename)));
        }
        return Optional.ofNullable(file);
    }

    private void checkNonNull(String variableName, Object value) {
        if (value == null) {
            throw new IllegalStateException(variableName + " may not be null");
        }
    }
}

