/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.registry.converter;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.registry.converter.AbstractEntityConverter;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.types.PhoneNumber;

public class PhoneNumberEntityConverter
extends AbstractEntityConverter {
    public void init(String value) {
    }

    public int getPriority() {
        return 1000;
    }

    @Override
    public boolean canConvertFrom(Object value, PropertyDescriptor valueDescriptor) {
        if (value instanceof String) {
            PhoneNumber phoneNumber = PhoneNumber.parse((String)((String)value));
            return phoneNumber.getInternal().isPresent();
        }
        return false;
    }

    @Override
    public MaltegoEntity convertFrom(Object value, MaltegoEntity template, PropertyDescriptor valueDescriptor, boolean resetIfSamplePart) {
        if (value instanceof String) {
            PhoneNumber phoneNumber = PhoneNumber.parse((String)((String)value));
            template.setValue(valueDescriptor, (Object)phoneNumber, true, resetIfSamplePart);
        }
        return template;
    }
}

