/**
 * TinyMCE core class.
 *
 * @static
 * @class tinymce
 * @borrow-members tinymce.EditorManager
 * @borrow-members tinymce.util.Tools
 */

/**
 * @property {tinymce.dom.DOMUtils} DOM Global DOM instance.
 * @property {tinymce.dom.ScriptLoader} ScriptLoader Global ScriptLoader instance.
 * @property {tinymce.AddOnManager} PluginManager Global PluginManager instance.
 * @property {tinymce.AddOnManager} ThemeManager Global ThemeManager instance.
 */

/**
 * Root level namespace this contains classes directly related to the TinyMCE editor.
 *
 * @namespace tinymce
 */

/**
 * Contains classes for handling the browsers DOM.
 *
 * @namespace tinymce.dom
 */

/**
 * Contains html parser and serializer logic.
 *
 * @namespace tinymce.html
 */

/**
 * Contains the different UI types such as buttons, listboxes etc.
 *
 * @namespace tinymce.ui
 */

/**
 * Contains various utility classes such as json parser, cookies etc.
 *
 * @namespace tinymce.util
 */

/**
 * Contains modules to handle data binding.
 *
 * @namespace tinymce.data
 */
