macro(VsNoCompileBatching_check tgt ofn_expect)
  set(vcProjectFile "${RunCMake_TEST_BINARY_DIR}/${tgt}.vcxproj")
  if(NOT EXISTS "${vcProjectFile}")
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not exist.")
    return()
  endif()

  set(HAVE_OFN 0)

  file(STRINGS "${vcProjectFile}" lines)
  foreach(line IN LISTS lines)
    if(line MATCHES "^ *<ObjectFileName>([^<>]+)</ObjectFileName>")
      set(ofn_actual "${CMAKE_MATCH_1}")
      if(NOT "${ofn_actual}" STREQUAL "${ofn_expect}")
        set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj has <ObjectFileName> '${ofn_actual}', not '${ofn_expect}'.")
        return()
      endif()
      set(HAVE_OFN 1)
      break()
    endif()
  endforeach()

  if(NOT HAVE_OFN)
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not have a <ObjectFileName> property.")
    return()
  endif()
endmacro()

VsNoCompileBatching_check(foo "$(IntDir)")
VsNoCompileBatching_check(foo_NB "$(IntDir)%(filename).obj")
VsNoCompileBatching_check(foo_NB_OFF "$(IntDir)")
