; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -passes=atomic-expand %s | FileCheck %s

define fp128 @test_atomicrmw_xchg_fp128_global_agent(ptr addrspace(1) %ptr, fp128 %value) {
; CHECK-LABEL: @test_atomicrmw_xchg_fp128_global_agent(
; CHECK-NEXT:    [[TMP1:%.*]] = addrspacecast ptr addrspace(1) [[PTR:%.*]] to ptr
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast fp128 [[VALUE:%.*]] to i128
; CHECK-NEXT:    [[TMP3:%.*]] = call i128 @__atomic_exchange_16(ptr [[TMP1]], i128 [[TMP2]], i32 5)
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast i128 [[TMP3]] to fp128
; CHECK-NEXT:    ret fp128 [[TMP4]]
;
  %res = atomicrmw xchg ptr addrspace(1) %ptr, fp128 %value syncscope("agent") seq_cst
  ret fp128 %res
}

define fp128 @test_atomicrmw_fadd_fp128_global_agent(ptr addrspace(1) %ptr, fp128 %value) {
; CHECK-LABEL: @test_atomicrmw_fadd_fp128_global_agent(
; CHECK-NEXT:    [[TMP1:%.*]] = alloca fp128, align 8, addrspace(5)
; CHECK-NEXT:    [[TMP2:%.*]] = load fp128, ptr addrspace(1) [[PTR:%.*]], align 16
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi fp128 [ [[TMP2]], [[TMP0:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ]
; CHECK-NEXT:    [[NEW:%.*]] = fadd fp128 [[LOADED]], [[VALUE:%.*]]
; CHECK-NEXT:    [[TMP3:%.*]] = addrspacecast ptr addrspace(1) [[PTR]] to ptr
; CHECK-NEXT:    call void @llvm.lifetime.start.p5(i64 16, ptr addrspace(5) [[TMP1]])
; CHECK-NEXT:    store fp128 [[LOADED]], ptr addrspace(5) [[TMP1]], align 8
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast fp128 [[NEW]] to i128
; CHECK-NEXT:    [[TMP5:%.*]] = call zeroext i1 @__atomic_compare_exchange_16(ptr [[TMP3]], ptr addrspace(5) [[TMP1]], i128 [[TMP4]], i32 5, i32 5)
; CHECK-NEXT:    [[TMP6:%.*]] = load fp128, ptr addrspace(5) [[TMP1]], align 8
; CHECK-NEXT:    call void @llvm.lifetime.end.p5(i64 16, ptr addrspace(5) [[TMP1]])
; CHECK-NEXT:    [[TMP7:%.*]] = insertvalue { fp128, i1 } poison, fp128 [[TMP6]], 0
; CHECK-NEXT:    [[TMP8:%.*]] = insertvalue { fp128, i1 } [[TMP7]], i1 [[TMP5]], 1
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { fp128, i1 } [[TMP8]], 1
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { fp128, i1 } [[TMP8]], 0
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret fp128 [[NEWLOADED]]
;
  %res = atomicrmw fadd ptr addrspace(1) %ptr, fp128 %value syncscope("agent") seq_cst
  ret fp128 %res
}

define fp128 @test_atomicrmw_fsub_fp128_global_agent(ptr addrspace(1) %ptr, fp128 %value) {
; CHECK-LABEL: @test_atomicrmw_fsub_fp128_global_agent(
; CHECK-NEXT:    [[TMP1:%.*]] = alloca fp128, align 8, addrspace(5)
; CHECK-NEXT:    [[TMP2:%.*]] = load fp128, ptr addrspace(1) [[PTR:%.*]], align 16
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi fp128 [ [[TMP2]], [[TMP0:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ]
; CHECK-NEXT:    [[NEW:%.*]] = fsub fp128 [[LOADED]], [[VALUE:%.*]]
; CHECK-NEXT:    [[TMP3:%.*]] = addrspacecast ptr addrspace(1) [[PTR]] to ptr
; CHECK-NEXT:    call void @llvm.lifetime.start.p5(i64 16, ptr addrspace(5) [[TMP1]])
; CHECK-NEXT:    store fp128 [[LOADED]], ptr addrspace(5) [[TMP1]], align 8
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast fp128 [[NEW]] to i128
; CHECK-NEXT:    [[TMP5:%.*]] = call zeroext i1 @__atomic_compare_exchange_16(ptr [[TMP3]], ptr addrspace(5) [[TMP1]], i128 [[TMP4]], i32 5, i32 5)
; CHECK-NEXT:    [[TMP6:%.*]] = load fp128, ptr addrspace(5) [[TMP1]], align 8
; CHECK-NEXT:    call void @llvm.lifetime.end.p5(i64 16, ptr addrspace(5) [[TMP1]])
; CHECK-NEXT:    [[TMP7:%.*]] = insertvalue { fp128, i1 } poison, fp128 [[TMP6]], 0
; CHECK-NEXT:    [[TMP8:%.*]] = insertvalue { fp128, i1 } [[TMP7]], i1 [[TMP5]], 1
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { fp128, i1 } [[TMP8]], 1
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { fp128, i1 } [[TMP8]], 0
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret fp128 [[NEWLOADED]]
;
  %res = atomicrmw fsub ptr addrspace(1) %ptr, fp128 %value syncscope("agent") seq_cst
  ret fp128 %res
}

define fp128 @test_atomicrmw_fmin_fp128_global_agent(ptr addrspace(1) %ptr, fp128 %value) {
; CHECK-LABEL: @test_atomicrmw_fmin_fp128_global_agent(
; CHECK-NEXT:    [[TMP1:%.*]] = alloca fp128, align 8, addrspace(5)
; CHECK-NEXT:    [[TMP2:%.*]] = load fp128, ptr addrspace(1) [[PTR:%.*]], align 16
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi fp128 [ [[TMP2]], [[TMP0:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ]
; CHECK-NEXT:    [[TMP3:%.*]] = call fp128 @llvm.minnum.f128(fp128 [[LOADED]], fp128 [[VALUE:%.*]])
; CHECK-NEXT:    [[TMP4:%.*]] = addrspacecast ptr addrspace(1) [[PTR]] to ptr
; CHECK-NEXT:    call void @llvm.lifetime.start.p5(i64 16, ptr addrspace(5) [[TMP1]])
; CHECK-NEXT:    store fp128 [[LOADED]], ptr addrspace(5) [[TMP1]], align 8
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast fp128 [[TMP3]] to i128
; CHECK-NEXT:    [[TMP6:%.*]] = call zeroext i1 @__atomic_compare_exchange_16(ptr [[TMP4]], ptr addrspace(5) [[TMP1]], i128 [[TMP5]], i32 5, i32 5)
; CHECK-NEXT:    [[TMP7:%.*]] = load fp128, ptr addrspace(5) [[TMP1]], align 8
; CHECK-NEXT:    call void @llvm.lifetime.end.p5(i64 16, ptr addrspace(5) [[TMP1]])
; CHECK-NEXT:    [[TMP8:%.*]] = insertvalue { fp128, i1 } poison, fp128 [[TMP7]], 0
; CHECK-NEXT:    [[TMP9:%.*]] = insertvalue { fp128, i1 } [[TMP8]], i1 [[TMP6]], 1
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { fp128, i1 } [[TMP9]], 1
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { fp128, i1 } [[TMP9]], 0
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret fp128 [[NEWLOADED]]
;
  %res = atomicrmw fmin ptr addrspace(1) %ptr, fp128 %value syncscope("agent") seq_cst
  ret fp128 %res
}

define fp128 @test_atomicrmw_fmax_fp128_global_agent(ptr addrspace(1) %ptr, fp128 %value) {
; CHECK-LABEL: @test_atomicrmw_fmax_fp128_global_agent(
; CHECK-NEXT:    [[TMP1:%.*]] = alloca fp128, align 8, addrspace(5)
; CHECK-NEXT:    [[TMP2:%.*]] = load fp128, ptr addrspace(1) [[PTR:%.*]], align 16
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi fp128 [ [[TMP2]], [[TMP0:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ]
; CHECK-NEXT:    [[TMP3:%.*]] = call fp128 @llvm.maxnum.f128(fp128 [[LOADED]], fp128 [[VALUE:%.*]])
; CHECK-NEXT:    [[TMP4:%.*]] = addrspacecast ptr addrspace(1) [[PTR]] to ptr
; CHECK-NEXT:    call void @llvm.lifetime.start.p5(i64 16, ptr addrspace(5) [[TMP1]])
; CHECK-NEXT:    store fp128 [[LOADED]], ptr addrspace(5) [[TMP1]], align 8
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast fp128 [[TMP3]] to i128
; CHECK-NEXT:    [[TMP6:%.*]] = call zeroext i1 @__atomic_compare_exchange_16(ptr [[TMP4]], ptr addrspace(5) [[TMP1]], i128 [[TMP5]], i32 5, i32 5)
; CHECK-NEXT:    [[TMP7:%.*]] = load fp128, ptr addrspace(5) [[TMP1]], align 8
; CHECK-NEXT:    call void @llvm.lifetime.end.p5(i64 16, ptr addrspace(5) [[TMP1]])
; CHECK-NEXT:    [[TMP8:%.*]] = insertvalue { fp128, i1 } poison, fp128 [[TMP7]], 0
; CHECK-NEXT:    [[TMP9:%.*]] = insertvalue { fp128, i1 } [[TMP8]], i1 [[TMP6]], 1
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { fp128, i1 } [[TMP9]], 1
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { fp128, i1 } [[TMP9]], 0
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret fp128 [[NEWLOADED]]
;
  %res = atomicrmw fmax ptr addrspace(1) %ptr, fp128 %value syncscope("agent") seq_cst
  ret fp128 %res
}
