; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=licm -S < %s | FileCheck %s

;; C reproducer:
;; void f(int *ptr, int n) {
;;   for (int i = 0; i < n; ++i) {
;;     int x = *ptr;
;;     if (x)
;;       break;
;;
;;     *ptr = x + 1;
;;   }
;; }

define dso_local void @f(ptr nocapture %ptr, i32 %n) {
; CHECK-LABEL: @f(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP7:%.*]] = icmp slt i32 0, [[N:%.*]]
; CHECK-NEXT:    br i1 [[CMP7]], label [[FOR_BODY_LR_PH:%.*]], label [[CLEANUP1:%.*]]
; CHECK:       for.body.lr.ph:
; CHECK-NEXT:    [[PTR_PROMOTED:%.*]] = load i32, ptr [[PTR:%.*]], align 4
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[TMP0:%.*]] = phi i32 [ [[PTR_PROMOTED]], [[FOR_BODY_LR_PH]] ], [ 1, [[IF_END:%.*]] ]
; CHECK-NEXT:    [[I_08:%.*]] = phi i32 [ 0, [[FOR_BODY_LR_PH]] ], [ [[INC:%.*]], [[IF_END]] ]
; CHECK-NEXT:    [[TOBOOL_NOT:%.*]] = icmp eq i32 [[TMP0]], 0
; CHECK-NEXT:    br i1 [[TOBOOL_NOT]], label [[IF_END]], label [[FOR_BODY_CLEANUP1_CRIT_EDGE:%.*]]
; CHECK:       if.end:
; CHECK-NEXT:    store i32 1, ptr [[PTR]], align 4
; CHECK-NEXT:    [[INC]] = add nuw nsw i32 [[I_08]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[INC]], [[N]]
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[FOR_COND_CLEANUP1_CRIT_EDGE:%.*]]
; CHECK:       for.body.cleanup1_crit_edge:
; CHECK-NEXT:    br label [[CLEANUP1]]
; CHECK:       for.cond.cleanup1_crit_edge:
; CHECK-NEXT:    br label [[CLEANUP1]]
; CHECK:       cleanup1:
; CHECK-NEXT:    ret void
;
entry:
  %cmp7 = icmp slt i32 0, %n
  br i1 %cmp7, label %for.body.lr.ph, label %cleanup1

for.body.lr.ph:                                   ; preds = %entry
  br label %for.body

for.body:                                         ; preds = %for.body.lr.ph, %if.end
  %i.08 = phi i32 [ 0, %for.body.lr.ph ], [ %inc, %if.end ]
  %0 = load i32, ptr %ptr, align 4
  %tobool.not = icmp eq i32 %0, 0
  br i1 %tobool.not, label %if.end, label %for.body.cleanup1_crit_edge

if.end:                                           ; preds = %for.body
  store i32 1, ptr %ptr, align 4
  %inc = add nuw nsw i32 %i.08, 1
  %cmp = icmp slt i32 %inc, %n
  br i1 %cmp, label %for.body, label %for.cond.cleanup1_crit_edge

for.body.cleanup1_crit_edge:                      ; preds = %for.body
  br label %cleanup1

for.cond.cleanup1_crit_edge:                      ; preds = %if.end
  br label %cleanup1

cleanup1:                                         ; preds = %for.cond.cleanup1_crit_edge, %for.body.cleanup1_crit_edge, %entry
  ret void
}
