#include <string>
using std::string;
#include <stdio.h>
#include "crypto_stream_salsa20.h"
#include "crypto_hash_sha256.h"

char secondkey_bytes[32] = {
 0xdc,0x90,0x8d,0xda,0x0b,0x93,0x44,0xa9
,0x53,0x62,0x9b,0x73,0x38,0x20,0x77,0x88
,0x80,0xf3,0xce,0xb4,0x21,0xbb,0x61,0xb9
,0x1c,0xbd,0x4c,0x3e,0x66,0x25,0x6c,0xe4
} ;

char noncesuffix_bytes[8] = {
 0x82,0x19,0xe0,0x03,0x6b,0x7a,0x0b,0x37
} ;

main()
{
  int i;
  string secondkey(secondkey_bytes,sizeof secondkey_bytes);
  string noncesuffix(noncesuffix_bytes,sizeof noncesuffix_bytes);
  string output = crypto_stream_salsa20(4194304,noncesuffix,secondkey);
  string h = crypto_hash_sha256(output);
  for (i = 0;i < 32;++i) printf("%02x",(unsigned int) (unsigned char) h[i]); printf("\n");
  return 0;
}
