# Pure cmake script to write out cmake_commit.c and cmake_version.but

set(DEFAULT_COMMIT "4ff82ab29a22936b78510c68f544a99e677efed3")
set(commit "${DEFAULT_COMMIT}")

set(TOPLEVEL_SOURCE_DIR ${CMAKE_SOURCE_DIR})

execute_process(
  COMMAND ${GIT_EXECUTABLE} rev-parse --show-toplevel
  OUTPUT_VARIABLE git_worktree
  ERROR_VARIABLE stderr
  RESULT_VARIABLE status)
string(REGEX REPLACE "\n$" "" git_worktree "${git_worktree}")

if(status EQUAL 0)
  if(git_worktree STREQUAL CMAKE_SOURCE_DIR)
    execute_process(
      COMMAND ${GIT_EXECUTABLE} rev-parse HEAD
      OUTPUT_VARIABLE git_commit
      ERROR_VARIABLE stderr
      RESULT_VARIABLE status)
    if(status EQUAL 0)
      string(REGEX REPLACE "\n$" "" commit "${git_commit}")
    else()
      if(commit STREQUAL "unavailable")
        message("Unable to determine git commit: 'git rev-parse HEAD' returned status ${status} and error output:\n${stderr}\n")
      endif()
    endif()
  else()
    if(commit STREQUAL "unavailable")
      message("Unable to determine git commit: top-level source dir ${CMAKE_SOURCE_DIR} is not the root of a repository")
    endif()
  endif()
else()
  if(commit STREQUAL "unavailable")
    message("Unable to determine git commit: 'git rev-parse --show-toplevel' returned status ${status} and error output:\n${stderr}\n")
  endif()
endif()

if(OUTPUT_TYPE STREQUAL header)
  file(WRITE "${OUTPUT_FILE}" "\
/*
 * cmake_commit.c - string literal giving the source git commit, if known.
 *
 * Generated by cmake/gitcommit.cmake.
 */

#include \"putty.h\"
const char commitid[] = \"${commit}\";
")
elseif(OUTPUT_TYPE STREQUAL halibut)
  if(commit STREQUAL "unavailable")
    file(WRITE "${OUTPUT_FILE}" "\
\\versionid no version information available
")
  else()
    file(WRITE "${OUTPUT_FILE}" "\
\\versionid built from git commit ${commit}
")
  endif()
else()
  message(FATAL_ERROR "Set OUTPUT_TYPE when running this script")
endif()
