## RabbitMQ 3.7.5

RabbitMQ `3.7.5` a maintenance release that primarily includes bug fixes.

### Upgrades and Compatibility

This release includes one **potential incompatibility** with earlier `3.7.x` releases. It will only affect applications that use a lot (at least hundreds) of channels per connection. Previous behavior can be restored via configuration.

See [3.7.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.0) upgrade and compatibility notes if upgrading from an earlier release.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades.

See [RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.


## Changes

### Core Server

#### Bug Fixes

 * Topic authorisation check could fail with an exception.
 
   GitHub issue: [rabbitmq-server#1538](https://github.com/rabbitmq/rabbitmq-server/issues/1538)

 * Some runtime parameters and operator policies were rejected during definition import.
 
   GitHub issue: [rabbitmq-management#565](https://github.com/rabbitmq/rabbitmq-management/issues/565), [rabbitmq-federation#73](https://github.com/rabbitmq/rabbitmq-federation/issues/73)

 * Queues could run into an exception under memory pressure.
 
   GitHub issue: [rabbitmq-server#1582](https://github.com/rabbitmq/rabbitmq-server/issues/1582)

 * During parallel cluster formation nodes could run into an exception when inserting seed data
   (default virtual host, user and permissions).

   GitHub issue: [rabbitmq-server#1556](https://github.com/rabbitmq/rabbitmq-server/pull/1556)

#### Enhancements

 * New `ha-promote-on-failure` queue mirroring setting to augment already existing `ha-promote-on-shutdown`.
 
   GitHub issue: [rabbitmq-server#1578](https://github.com/rabbitmq/rabbitmq-server/pull/1578)

 * `queue.delete` operations will now force delete queues that don't have a [promotable
   master](https://www.rabbitmq.com/ha.html#unsynchronised-mirrors).
   
   GitHub issue: [rabbitmq-server#1501](https://github.com/rabbitmq/rabbitmq-server/issues/1501)

 * Lock contention in internal database is now much lower when a node with a lot of exclusive queues
   shuts down or is otherwise considered to be unavailable by peers. This means fewer CPU cycles
   spent cleaning up the exclusive queues.
   
   GitHub issue: [rabbitmq-server#1570](https://github.com/rabbitmq/rabbitmq-server/pull/1570)

 * Default [max number of channels allowed on a connection](https://www.rabbitmq.com/networking.html#tuning-for-large-number-of-connections-channel-max) (a.k.a. `channel_max`) has been lowered from `65535` to `2047`.
   The new default is much safer and will reduce the effect application channel leaks have on node resource consumption. **This is a potentially breaking change**.
   
   Systems where a lot (at least hundreds) of channels *per connection* are used should explicitly override `channel_max` in the [config file](https://www.rabbitmq.com/configure.html) to a higher suitable value, e.g.:
   
   ```
   channel_max = 4000
   ```
   
   GitHub issue: [rabbitmq-server#1593](https://github.com/rabbitmq/rabbitmq-server/issues/1593)

  * [Ranch](https://github.com/ninenines/ranch) dependency has been updated to `1.5.x` which should prevent rare cases of mass termination of client connections.


### CLI Tools

#### Bug Fixes

 * `-t` (`--timeout`) is now only displayed for commands that will actually use it.
 
   GitHub issue: [rabbitmq-cli#236](https://github.com/rabbitmq/rabbitmq-cli/issues/236)


### Management Plugin

#### Bug Fixes

  * `GET /api/overview` could fail if SNI for management plugin listener was configured.
  
    GitHub issue: [rabbitmq-management#567](https://github.com/rabbitmq/rabbitmq-management/issues/567)

 * `rabbitmqadmin` could run into an exception with certain formatting settings on Python 2.x.
 
    GitHub issue: [rabbitmq-management#568](https://github.com/rabbitmq/rabbitmq-management/issues/568)

  * HTTP API stats documentation used incorrect field names.
  
    GitHub issue: [rabbitmq-management#561](https://github.com/rabbitmq/rabbitmq-management/pull/561)


### LDAP Plugin

#### Bug Fixes

 * LDAP server-initiated connection closure was not handled gracefully by connection pool.
   Kudos to Adam Gardner for [doing all the hard work](https://groups.google.com/forum/#!topic/rabbitmq-users/4Gva3h-yJzM) investigating this issue.
 
   GitHub issues: [rabbitmq-auth-backend-ldap#82](https://github.com/rabbitmq/rabbitmq-auth-backend-ldap/issues/82), [rabbitmq-auth-backend-ldap#90](https://github.com/rabbitmq/rabbitmq-auth-backend-ldap/issues/90)

 * `auth_ldap.idle_timeout` now defaults to 300 seconds instead of `infinity`.
 
   GitHub issue: [rabbitmq-auth-backend-ldap#81](https://github.com/rabbitmq/rabbitmq-auth-backend-ldap/issues/81)

 * `group_lookup_base` was not configurable via the new style config format.
 
   GitHub issue: [rabbitmq-auth-backend-ldap#85](https://github.com/rabbitmq/rabbitmq-auth-backend-ldap/issues/85)

 * `auth_ldap.log` didn't accept `network_unsafe` for severity value.

   GitHub issue: [rabbitmq-auth-backend-ldap#86](https://github.com/rabbitmq/rabbitmq-auth-backend-ldap/issues/86)

#### Enhancements

 * It is now possible to configure TLS options for LDAP server connections via the [new style config format](https://www.rabbitmq.com/configure.html).
 
   GitHub issue: [rabbitmq-auth-backend-ldap#88](https://github.com/rabbitmq/rabbitmq-auth-backend-ldap/issues/88)


### Federation Plugin

#### Bug Fixes

  * Federation upstream sets could run into a type error with exchange federation.
  
    GitHub issue: [rabbitmq-federation#75](https://github.com/rabbitmq/rabbitmq-federation/issues/75)


### Shovel Plugin

#### Bug Fixes

  * Valid dynamic Shovel properties can be rejected by validation.

    GitHub issue: [rabbitmq-shovel#38](https://github.com/rabbitmq/rabbitmq-shovel/issues/38)

 * Shovel names are again included into (application-provided) connection names and can therefore
   be seen in the management UI.
   
   GitHub issue: [rabbitmq-shovel#40](https://github.com/rabbitmq/rabbitmq-shovel/issues/40)


### Peer Discovery AWS Plugin

#### Bug Fixes

  * China-based AWS regions now use a correct base API URI.
  
    GitHub issue: [rabbitmq-peer-discovery-aws#23](https://github.com/rabbitmq/rabbitmq-peer-discovery-aws/issues/23)

  * The plugin could fail to discover all nodes in a returned instance set.
  
    GitHub issue: [rabbitmq-peer-discovery-aws#20](https://github.com/rabbitmq/rabbitmq-peer-discovery-aws/issues/20)


### Peer Discovery Kubernetes Plugin

#### Enhnacements

  * The plugin now supports [randomized startup delay](https://www.rabbitmq.com/cluster-formation.html#initial-formation-race-condition) with much lower default values
    since RSD is [not really necessary](https://www.rabbitmq.com/cluster-formation.html#peer-discovery-k8s) for stateful set deployments.
    
    GitHub issue: [rabbitmq-peer-discovery-k8s#23](https://github.com/rabbitmq/rabbitmq-peer-discovery-k8s/issues/23)


### AMQP 1.0 Client

#### Bug Fixes

  * It wasn't possible to send some messages using QPid JMS client over AMQP 1.0.
  
    GitHub issue: [rabbitmq-amqp1.0#61](https://github.com/rabbitmq/rabbitmq-amqp1.0/issues/61)


### Web MQTT Plugin

#### Bug Fixes

  * New style config format was not interpreting IP addresses correctly.
  
    GitHub issue: [rabbitmq-web-mqtt#26](https://github.com/rabbitmq/rabbitmq-web-mqtt/issues/26)


### Web STOMP Plugin

#### Bug Fixes

  * It wasn't possible to configure TCP listener(s) in the new style config format.
  
    GitHub issue: [rabbitmq-web-stomp#82](https://github.com/rabbitmq/rabbitmq-web-stomp/issues/82)



## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-3.7.5.tar.gz`.
