# How to service a library

This document provides the steps that need to be followed after modifying a library in a servicing branch.

Servicing branches represent shipped versions of .NET, and their name is in the format `release/X.0-staging`. Examples:

- `release/8.0-staging`
- `release/7.0-staging`
- `release/6.0-staging`

## Check if a package is generated

If a library is packable (check for the `<IsPackable>true</IsPackable>` property) you'll need to set `<GeneratePackageOnBuild>true</GeneratePackageOnBuild>` in the source project. That is necessary as packages aren't generated by default in servicing releases.

## Determine ServiceVersion

When you make a change to a library & ship it during the servicing release, the `ServicingVersion` must be bumped. This property is found in the library's source project. It's also possible that the property is not in that file, in which case you'll need to add it to the library's source project and set it to 1. If the property is already present in your library's source project, just increment the servicing version by 1.

## Optionally ensure all up-stack packages are also produced

If you wish to ensure that every package that references a serviced package is also serviced itself, you can enable validation by setting `ServiceTransitiveDependencies` to true.  This can be done in an individual project, or globally.  When doing this then building the repo, eg: `build libs -allConfigurations` you'll see errors from any project that didn't enable servicing.  Reasons for forcing packages which depend on your package to service are security servicing or removing dependencies.

## Test your changes

All that's left is to ensure that your changes have worked as expected. To do so, execute the following steps:

1. From a clean copy of your branch, run `build.cmd/sh libs -allconfigurations`

2. Check in `artifacts\bin\packages\Debug` for the existence of your package, with the appropriate package version.

3. Try installing the built package in a test application, testing that your changes to the library are present & working as expected.
   To install your package add your local packages folder as a feed source in VS or your nuget.config and then add a PackageReference to the specific version of the package you built then try using the APIs.

## Approval Process

All the servicing change must go through an approval process. You have two ways to submit your PR:

- By manually creating your PR using [this template](https://raw.githubusercontent.com/dotnet/runtime/main/.github/PULL_REQUEST_TEMPLATE/servicing_pull_request_template.md).
- Or by asking the bot to automatically create the servicing PR for you using a merged `main` PR as source. This method requires typing an AzDO backport command as a comment of your merged PR using the format `/backport to release/X.0-staging`. Examples:

  - `/backport to release/8.0-staging`
  - `/backport to release/7.0-staging`
  - `/backport to release/6.0-staging`

For all cases, you must:

- Fill out the template of the PR description.
- Bring it to the attention of the [engineering lead responsible for the area](~/docs/area-owners.md).
- If the fix is a product change, the area owner will:
  - Add the `Servicing-consider` label.
  - Ask the area owner to champion your PR in the .NET Tactics meeting to request merge approval.
  - If the change is approved, they will replace the `Servicing-consider` label by `Servicing-approved` and sign-off the PR.
- If the fix is a test-only or infra-only change, the area owner will:
  - Review the PR and sign-off if they approve it.
  - Add the `Servicing-approved` label.

The area owner can then merge the PR once the CI looks good (it's either green or the failures are investigated and determined to be unrelated to the PR).

**Note**: Applying the `Servicing-approved` label ensures the `check-service-labels` CI job passes, which is a mandatory requirement for merging a PR in a servicing branch.
