#include "unity-webapps-runner-amazon.h"
#include <geoclue/geoclue-address.h>
#include <gio/gio.h>

#define UBUNTU_GEOIP_PROVIDER_SERVICE "org.freedesktop.Geoclue.Providers.UbuntuGeoIP"
#define UBUNTU_GEOIP_PROVIDER_PATH "/org/freedesktop/Geoclue/Providers/UbuntuGeoIP"

#define DEFAULT_AMAZON_DESKTOP "application://ubuntu-amazon-default.desktop"

gchar *
unity_webapps_runner_amazon_get_country (void)
{
  GeoclueAddress *address;
  GeoclueAccuracy * accuracy;
  GeoclueAccuracyLevel level;
  GHashTable *address_details;
  gchar *country;
  gboolean got_address;
  GError *error;

  address = geoclue_address_new (UBUNTU_GEOIP_PROVIDER_SERVICE,
				 UBUNTU_GEOIP_PROVIDER_PATH);

  error = NULL;
  country = NULL;
  accuracy = NULL;

  got_address = geoclue_address_get_address (address, NULL, &address_details, &accuracy, &error);
  if (got_address == FALSE)
    {
      g_warning ("Failed to fetch address from Geoclue: %s", error->message);
      g_error_free (error);
      goto out;
    }

  geoclue_accuracy_get_details(accuracy, &level, NULL, NULL);
  if (GEOCLUE_ACCURACY_LEVEL_NONE == level)
    {
      g_warning ("Could not get a proper accuracy from Geoclue (NONE)");
      g_hash_table_destroy (address_details);
      goto out;
    }

  country = g_strdup (g_hash_table_lookup (address_details, "country"));
  g_hash_table_destroy (address_details);
  
 out:
  geoclue_accuracy_free(accuracy);
  g_object_unref (G_OBJECT (address));
  return country;
}

static GHashTable *
unity_webapps_runner_amazon_get_desktops_by_country ()
{
  GHashTable *desktops_by_country;
  
  desktops_by_country = g_hash_table_new_full (g_str_hash, g_str_equal, NULL, NULL);
  
  g_hash_table_insert (desktops_by_country, "Canada", "http://amazon.ca/?tag=u1webapp-ca-20");
  g_hash_table_insert (desktops_by_country, "China", "http://amazon.cn/?tag=u1webapp-23");
  g_hash_table_insert (desktops_by_country, "United Kingdom", "http://amazon.co.uk/?tag=u1webapp-uk-21");
  g_hash_table_insert (desktops_by_country, "France", "http://amazon.fr/?tag=u1webapp-fr-21");
  g_hash_table_insert (desktops_by_country, "Italy", "http://amazon.it/?tag=u1webapp-it-21");
  g_hash_table_insert (desktops_by_country, "Spain", "http://amazon.es/?tag=u1webapp-es-21");
  g_hash_table_insert (desktops_by_country, "Germany", "http://amazon.de/?tag=u1webapp-21");
  g_hash_table_insert (desktops_by_country, "Japan", "http://amazon.co.jp/?tag=u1webapp-22");
  
  return desktops_by_country;
}

const gchar *
unity_webapps_runner_amazon_get_homepage_for_country (const gchar *country)
{
  static const gchar * DEFAULT_AMAZON_URL = "http://www.amazon.com/?tag=u1webapp-20";
  static GHashTable *desktops_by_country = NULL;
  const gchar *ret;
  
  if (desktops_by_country == NULL)
    {
      desktops_by_country = unity_webapps_runner_amazon_get_desktops_by_country ();
    }
  
  if (country == NULL)
    {
      return DEFAULT_AMAZON_URL;
    }

  ret = g_hash_table_lookup (desktops_by_country, country);
  if (ret == NULL)
    {
      return DEFAULT_AMAZON_URL;
    }
  return ret;
}



