/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-url-index.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */


#ifndef __UNITY_WEBAPPS_URL_INDEX_H
#define __UNITY_WEBAPPS_URL_INDEX_H


#define UNITY_WEBAPPS_TYPE_URL_INDEX              (unity_webapps_url_index_get_type())
#define UNITY_WEBAPPS_URL_INDEX(obj)              (G_TYPE_CHECK_INSTANCE_CAST((obj), UNITY_WEBAPPS_TYPE_URL_INDEX, UnityWebappsUrlIndex))
#define UNITY_WEBAPPS_URL_INDEX_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST((klass), UNITY_WEBAPPS_TYPE_URL_INDEX, UnityWebappsUrlIndexClass))
#define UNITY_WEBAPPS_IS_URL_INDEX(obj)           (G_TYPE_CHECK_INSTANCE_TYPE((obj), UNITY_WEBAPPS_TYPE_URL_INDEX))
#define UNITY_WEBAPPS_IS_URL_INDEX_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_WEBAPPS_TYPE_URL_INDEX))
#define UNITY_WEBAPPS_URL_INDEX_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS((obj), UNITY_WEBAPPS_TYPE_URL_INDEX, UnityWebappsUrlIndexClass))

typedef struct _UnityWebappsUrlIndexPrivate UnityWebappsUrlIndexPrivate;

typedef struct _UnityWebappsUrlIndex UnityWebappsUrlIndex;


struct _UnityWebappsUrlIndex {
	GObject object;

	UnityWebappsUrlIndexPrivate *priv;
};

typedef struct _UnityWebappsUrlIndexClass UnityWebappsUrlIndexClass;

struct _UnityWebappsUrlIndexClass
{
	GObjectClass parent_class;
	
	GList * (*lookup_url) (UnityWebappsUrlIndex *self, const gchar *url);
};

GType unity_webapps_url_index_get_type (void) G_GNUC_CONST;

GList *unity_webapps_url_index_lookup_url (UnityWebappsUrlIndex *manager, const gchar *url);

#endif
