<?xml version="1.0"?>

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:import href="rev_utils.xsl"/>

<xsl:output method="xml" media-type="text/html" omit-xml-declaration="yes" />

<xsl:variable name="registry" select="document('registry.xml')/registry" />

<xsl:template match="/">
  <xsl:text disable-output-escaping='yes'>&lt;!DOCTYPE html>
  </xsl:text>
<xsl:comment>AUTOGENERATED FILE - DO NOT EDIT - SEE Makefile</xsl:comment>
<xsl:text>
</xsl:text>
  <xsl:apply-templates />
</xsl:template>

<xsl:template match="*|node()">
  <xsl:copy>
    <xsl:copy-of select="@*" />
    <xsl:apply-templates select="node()" />
    <xsl:if test="not(local-name()='area' or local-name()='base' or local-name()='br' or local-name()='col' or local-name()='command' or local-name()='embed' or local-name()='hr' or local-name()='img' or local-name()='input' or local-name()='keygen' or local-name()='link' or local-name()='meta' or local-name()='param' or local-name()='source')">
      <xsl:if test="count(*|text())=0">
        <!-- this element is not allowed to be void so emit a space -->
        <xsl:text> </xsl:text>
      </xsl:if>
    </xsl:if>
  </xsl:copy>
</xsl:template>

<xsl:template match="extension|draft|ratified">
  <li value="{number}">
    <a href="{@href}"><xsl:value-of select="name" /></a>
  </li>
</xsl:template>

<xsl:template match="proposal">
  <li>
    <a href="{@href}"><xsl:value-of select="name" /></a>
  </li>
</xsl:template>

<xsl:template match="ol[@id='ratified-by-number']">
  <xsl:choose><xsl:when test="count($registry/ratified)!=0">
  <xsl:copy>
    <xsl:apply-templates select="$registry/ratified">
      <xsl:sort select="number" data-type="number" order="ascending" />
    </xsl:apply-templates>
  </xsl:copy>
  </xsl:when><xsl:otherwise>
  <xsl:text> </xsl:text>
  </xsl:otherwise></xsl:choose>
</xsl:template>

<xsl:template match="ol[@id='ratified-by-name']">
  <xsl:choose><xsl:when test="count($registry/ratified)!=0">
  <xsl:copy>
    <xsl:apply-templates select="$registry/ratified">
      <xsl:sort select="name"/>
    </xsl:apply-templates>
  </xsl:copy>
  </xsl:when><xsl:otherwise>
  <xsl:text> </xsl:text>
  </xsl:otherwise></xsl:choose>
</xsl:template>

<xsl:template match="ol[@id='community-approved-by-number']">
  <xsl:copy>
    <xsl:apply-templates select="$registry/extension">
      <xsl:sort select="number" data-type="number" order="ascending" />
    </xsl:apply-templates>
  </xsl:copy>
</xsl:template>

<xsl:template match="ol[@id='community-approved-by-name']">
  <xsl:copy>
    <xsl:apply-templates select="$registry/extension">
      <xsl:sort select="name"/>
    </xsl:apply-templates>
  </xsl:copy>
</xsl:template>

<xsl:template match="ol[@id='draft-by-number']">
  <xsl:copy>
    <xsl:apply-templates select="$registry/draft">
      <xsl:sort select="number" data-type="number" order="ascending" />
    </xsl:apply-templates>
  </xsl:copy>
</xsl:template>

<xsl:template match="ol[@id='draft-by-name']">
  <xsl:copy>
    <xsl:apply-templates select="$registry/draft">
      <xsl:sort select="name"/>
    </xsl:apply-templates>
  </xsl:copy>
</xsl:template>

<xsl:template match="ul[@id='proposed-by-name']">
  <xsl:copy>
    <xsl:apply-templates select="$registry/proposal">
      <xsl:sort select="name"/>
    </xsl:apply-templates>
  </xsl:copy>
</xsl:template>

<xsl:template match="ol[@id='recent-revisions']">
  <xsl:copy>
    <xsl:for-each select="$registry/*/history/revision">
      <xsl:sort select="@date" order="descending"/>
      <xsl:sort select="@number" order="descending"/>
      <xsl:if test="position() &lt; 11">
        <li>
          <a href="{../../@href}"><xsl:value-of select="../../name" /></a>
          <xsl:text> : revision </xsl:text>
          <xsl:value-of select="@number"/>
          <xsl:text> on </xsl:text>
          <time datetime="{translate(@date,'/','-')}">
            <xsl:call-template name="month_of_date">
              <xsl:with-param name="date" select="@date"/>
            </xsl:call-template><xsl:text> </xsl:text>
            <xsl:value-of select="substring(@date,9,2)"/>
            <xsl:text>, </xsl:text>
            <xsl:value-of select="substring(@date,1,4)"/>
          </time>
          <ul>
            <xsl:for-each select="change">
              <li><xsl:copy-of select="node()"/></li>
            </xsl:for-each>
          </ul>
        </li>        
      </xsl:if>
    </xsl:for-each>
  </xsl:copy>
</xsl:template>
  
</xsl:stylesheet>
