# Copyright 2019 Red Hat, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

from openstack import _hacking
from openstack.tests.unit import base


class HackingTestCase(base.TestCase):
    """This class tests the hacking checks in openstack._hacking.checks.

    It works by passing strings to the check methods like the pep8/flake8
    parser would. The parser loops over each line in the file and then passes
    the parameters to the check method. The parameter names in the check method
    dictate what type of object is passed to the check method.

    The parameter types are::

        logical_line: A processed line with the following modifications:
            - Multi-line statements converted to a single line.
            - Stripped left and right.
            - Contents of strings replaced with "xxx" of same length.
            - Comments removed.
        physical_line: Raw line of text from the input file.
        lines: a list of the raw lines from the input file
        tokens: the tokens that contribute to this logical line
        line_number: line number in the input file
        total_lines: number of lines in the input file
        blank_lines: blank lines before this one
        indent_char: indentation character in this file (" " or "\t")
        indent_level: indentation (with tabs expanded to multiples of 8)
        previous_indent_level: indentation on previous line
        previous_logical: previous logical line
        filename: Path of the file being run through pep8

    When running a test on a check method the return will be False/None if
    there is no violation in the sample input. If there is an error a tuple is
    returned with a position in the line, and a message. So to check the result
    just assertTrue if the check is expected to fail and assertFalse if it
    should pass.
    """

    def test_assert_no_setupclass(self):
        self.assertEqual(
            len(list(_hacking.assert_no_setupclass("def setUpClass(cls)"))), 1
        )

        self.assertEqual(
            len(list(_hacking.assert_no_setupclass("# setUpClass is evil"))), 0
        )

        self.assertEqual(
            len(
                list(
                    _hacking.assert_no_setupclass(
                        "def setUpClassyDrinkingLocation(cls)"
                    )
                )
            ),
            0,
        )
