## RabbitMQ 3.13.3

RabbitMQ `3.13.3` is a maintenance release in the `3.13.x` [release series](https://www.rabbitmq.com/release-information).

**Please skip this release and upgrade straight to `3.13.6`** or a later version (if available).

Starting June 1st, 2024, community support for this series will only be provided to [regularly contributing users](https://github.com/rabbitmq/rabbitmq-server/blob/main/COMMUNITY_SUPPORT.md) and those
who hold a valid [commercial support license](https://tanzu.vmware.com/rabbitmq/oss).

Please refer to the upgrade section from the [3.13.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.13.0)
if upgrading from a version prior to 3.13.0.

This release requires Erlang 26 and supports Erlang versions up to `26.2.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/docs/which-erlang) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.13.0, RabbitMQ requires Erlang 26. Nodes **will fail to start** on older Erlang releases.

Users upgrading from 3.12.x (or older releases) on Erlang 25 to 3.13.x on Erlang 26
(both RabbitMQ *and* Erlang are upgraded at the same time) **must** consult
the [v3.12.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.12.0) and [v3.13.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.13.0) first.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.13.x/release-notes).


### Core Broker

#### Bug Fixes

 * Fixes an exception in classic queue message store that produced large scary looking log entries.
   No data was lost as a result of the exception but clients could run into a channel error.

   GitHub issue: [#11292](https://github.com/rabbitmq/rabbitmq-server/pull/11292)

 * Corrected several 3.13-specific issues related to how the `x-death` headers are populated during [dead lettering](https://www.rabbitmq.com/docs/dlx).

   GitHub issues: [#11160](https://github.com/rabbitmq/rabbitmq-server/issues/11160), [#11159](https://github.com/rabbitmq/rabbitmq-server/issues/11159), [#11174](https://github.com/rabbitmq/rabbitmq-server/pull/11174), [#11339](https://github.com/rabbitmq/rabbitmq-server/pull/11339), [#10709](https://github.com/rabbitmq/rabbitmq-server/issues/10709), [#11331](https://github.com/rabbitmq/rabbitmq-server/issues/11331)

 * Per-virtual host queue (and stream) limit is now enforced for AMQP 1.0, MQTT, RabbitMQ Stream Protocol and STOMP as well as AMQP 0-9-1.

   Contributed by @SimonUnge.

   GitHub issue: [#11293](https://github.com/rabbitmq/rabbitmq-server/pull/11293)

 * Periodic replica reconciliation of quorum queues now reacts to node shutdown in cluster where Khepri is enabled.

   Contributed by @SimonUnge.

   GitHub issue: [#11134](https://github.com/rabbitmq/rabbitmq-server/pull/11134)

 * Declaration of an exchange of a non-existent type will now report a more suitable "precondition failed"
   error to the client.

   Contributed by @carlhoerberg.

   GitHub issue: [#11215](https://github.com/rabbitmq/rabbitmq-server/pull/11215)

 * Avoids a scary looking log message during node shutdown in certain plugin configurations.

   GitHub issue: [#11323](https://github.com/rabbitmq/rabbitmq-server/pull/11323)

#### Enhancements

 * `x-death` headers used to provide metadata about [dead-lettering](https://www.rabbitmq.com/docs/dlx) are now included
   for messages consumed from a stream.

   GitHub issue: [#11173](https://github.com/rabbitmq/rabbitmq-server/issues/11173)

 * Classic queue message store recovery was optimized (peak memory footprint-wise) for cases where large (multiple MiB in size) messages
   were routed to multiple queues.

   Contributed by @gomoripeti.

   GitHub issue: [#11072](https://github.com/rabbitmq/rabbitmq-server/issues/11072)

 * Besides the previously existing option of configuring default queue type per virtual host,
   there is now a "global" per node default that can be set via `rabbitmq.conf`:

   ``` ini
   # Changes default queue type for all clients connected to the configured node
   # to quorum queues.
   # This is just an example, not all queues should be quorum queues.
   # See https://www.rabbitmq.com/docs/quorum-queues to learn more.
   default_queue_type = quorum
   ```

   Contributed by @SimonUnge.

   GitHub issue: [#11163](https://github.com/rabbitmq/rabbitmq-server/pull/11163)

 * When a virtual host process stops, fails or is restarted, a clear message will now be logged.

   GitHub issue: [#11276](https://github.com/rabbitmq/rabbitmq-server/pull/11276)



### CLI Tools

#### Bug Fixes

 * `rabbitmq-plugins list` incorrectly marked disabled plugins as "pending an upgrade".

   Partially contributed by @gomoripeti.

   GitHub issue: [#11198](https://github.com/rabbitmq/rabbitmq-server/pull/11198)

 * `rabbitmqctl check_if_any_deprecated_features_are_used` could run into an exception.

   Partially contributed by @metron2.

   GitHub issue: [#11194](https://github.com/rabbitmq/rabbitmq-server/pull/11194)


### Prometheus Plugin

#### Enhancements

 * A new Prometheus-exposed metric, `rabbit_stream_segments`, indicates how many stream segment files
   there are on the target node.

   Contributed by @markus812498.

   GitHub issue: [#11325](https://github.com/rabbitmq/rabbitmq-server/pull/11325)


### Management Plugin

#### Bug Fixes

 * After signing out of management UI, the page was not refreshed to reflect updated login (session) status.

   GitHub issue: [#11224](https://github.com/rabbitmq/rabbitmq-server/issues/11224)


### Shovel Management Plugin

#### Bug Fixes

 * `rabbitmqctl delete_shovel` is now more effective at deleting Shovels that
    cannot start (for example, because they cannot connect using the configured URIs) and
    repeatedly fail, get restarted, fail again, get restarted, and so on.

    GitHub issue: [#11324](https://github.com/rabbitmq/rabbitmq-server/pull/11324)

 * `fail_if_no_peer_cert`, a server-side TLS setting, was removed from Shovel URI examples.
    Erlang 26's TLS implementation will refuse to accept it as a client-side setting whereas
    previously it was quietly ignored.

   Contributed by @womblep.

   GitHub issue: [#11318](https://github.com/rabbitmq/rabbitmq-server/pull/11318)


### Dependency Changes

None in this release.

## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.13.3.tar.xz`
instead of the source tarball produced by GitHub.
