/*
 * Copyright (c) 2000-2001 Silicon Graphics, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it would be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write the Free Software Foundation,
 * Inc.,  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#ifndef WIN_H
#define WIN_H

/* win.[ch] - windows into a very large file
 */

typedef intgen_t segix_t;

/* initialize the window abstraction
 */
void win_init( intgen_t fd,
	       off64_t rngoff,		/* offset into file of windowing */
	       size64_t winsz,		/* window size */
	       size_t wincntmax );	/* max number of windows to manage */

/* supply a pointer to the portion of the file identified by segix.
 */
void win_map( segix_t segix,		/* segment index to be mapped */
	      void **pp );		/* returns pointer by reference */

/* invalidate the pointer previously supplied. SIDE-EFFECT: zeros
 * by reference the caller's pointer.
 */
void win_unmap( segix_t segix,		/* must match win_map param */
	        void **pp );		/* ptr generated by win_map: ZEROED */

/*
 * Functions used to disable the window locking from happening.
 * This is used in the directory reconstruction phase where only
 * one thread is actually executing this code.
 *
 * Assumes called in region where only 1 thread can execute it.
 */
void win_locks_off(void);
void win_locks_on(void);

/*
 * Find out how many mmap calls were made for windows.
 */
size_t win_getnum_mmaps(void);

#endif /* WIN_H */
