/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.css;

import com.google.gwt.dev.util.TextOutput;
import com.google.gwt.resources.css.ast.Context;
import com.google.gwt.resources.css.ast.CssDef;
import com.google.gwt.resources.css.ast.CssEval;
import com.google.gwt.resources.css.ast.CssExternalSelectors;
import com.google.gwt.resources.css.ast.CssIf;
import com.google.gwt.resources.css.ast.CssMediaRule;
import com.google.gwt.resources.css.ast.CssNoFlip;
import com.google.gwt.resources.css.ast.CssNode;
import com.google.gwt.resources.css.ast.CssPageRule;
import com.google.gwt.resources.css.ast.CssProperty;
import com.google.gwt.resources.css.ast.CssRule;
import com.google.gwt.resources.css.ast.CssSelector;
import com.google.gwt.resources.css.ast.CssSprite;
import com.google.gwt.resources.css.ast.CssSubstitution;
import com.google.gwt.resources.css.ast.CssUnknownAtRule;
import com.google.gwt.resources.css.ast.CssUrl;
import com.google.gwt.resources.css.ast.CssVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssGenerationVisitor
extends CssVisitor {
    private final TextOutput out;
    private boolean needsOpenBrace;
    private boolean needsComma;
    private final boolean substituteDots;
    private final SortedMap<Integer, List<CssSubstitution>> substitutionPositions = new TreeMap<Integer, List<CssSubstitution>>();

    public CssGenerationVisitor(TextOutput out) {
        this(out, false);
    }

    public CssGenerationVisitor(TextOutput out, boolean substituteDots) {
        this.out = out;
        this.substituteDots = substituteDots;
    }

    @Override
    public void endVisit(CssIf x, Context ctx) {
        this.out.indentOut();
        this.out.printOpt("/* } */");
        this.out.newlineOpt();
    }

    @Override
    public void endVisit(CssMediaRule x, Context ctx) {
        this.out.indentOut();
        this.out.print("}");
        this.out.newlineOpt();
    }

    @Override
    public void endVisit(CssNoFlip x, Context ctx) {
        this.out.printOpt("/*} @noflip */");
        this.out.newlineOpt();
    }

    @Override
    public void endVisit(CssPageRule x, Context ctx) {
        this.out.indentOut();
        this.out.print("}");
        this.out.newlineOpt();
    }

    @Override
    public void endVisit(CssRule x, Context ctx) {
        if (!x.getProperties().isEmpty()) {
            this.closeBrace();
        }
    }

    @Override
    public void endVisit(CssUnknownAtRule x, Context ctx) {
        this.out.printOpt("/* Unknown at-rule */\n");
        this.out.print(x.getRule());
    }

    public SortedMap<Integer, List<CssSubstitution>> getSubstitutionPositions() {
        return this.substitutionPositions;
    }

    @Override
    public boolean visit(CssDef x, Context ctx) {
        this.out.printOpt("/* CssDef */");
        this.out.newlineOpt();
        return false;
    }

    @Override
    public boolean visit(CssEval x, Context ctx) {
        this.out.printOpt("/* CssEval */");
        this.out.newlineOpt();
        return false;
    }

    @Override
    public boolean visit(CssExternalSelectors x, Context ctx) {
        this.out.printOpt("/* @external");
        for (String className : x.getClasses()) {
            this.out.printOpt(" ");
            this.out.printOpt(className);
        }
        this.out.printOpt("; */");
        this.out.newlineOpt();
        return false;
    }

    @Override
    public boolean visit(CssIf x, Context ctx) {
        StringBuilder expr = new StringBuilder("/* @if ");
        if (x.getExpression() != null) {
            expr.append(x.getExpression()).append(" ");
        } else {
            expr.append(x.getPropertyName()).append(" ");
            for (String v : x.getPropertyValues()) {
                expr.append(v).append(" ");
            }
        }
        expr.append("{ */");
        this.out.printOpt(expr.toString());
        this.out.newlineOpt();
        this.out.indentIn();
        this.addSubstitition(x);
        return false;
    }

    @Override
    public boolean visit(CssMediaRule x, Context ctx) {
        this.out.print("@MEDIA");
        for (String m : x.getMedias()) {
            this.out.print(" " + m);
        }
        this.spaceOpt();
        this.out.print("{");
        this.out.newlineOpt();
        this.out.indentIn();
        return true;
    }

    @Override
    public boolean visit(CssNoFlip x, Context ctx) {
        this.out.printOpt("/*@noflip { */");
        this.out.newlineOpt();
        return true;
    }

    @Override
    public boolean visit(CssPageRule x, Context ctx) {
        this.out.print("@page");
        if (x.getPseudoPage() != null) {
            this.out.print(" :");
            this.out.print(x.getPseudoPage());
        }
        this.spaceOpt();
        this.out.print("{");
        this.out.newlineOpt();
        this.out.indentIn();
        return true;
    }

    @Override
    public boolean visit(CssProperty x, Context ctx) {
        if (this.needsOpenBrace) {
            this.openBrace();
            this.needsOpenBrace = false;
        }
        this.out.print(x.getName());
        this.colon();
        this.addSubstitition(x);
        if (x.isImportant()) {
            this.important();
        }
        this.semi();
        return true;
    }

    @Override
    public boolean visit(CssRule x, Context ctx) {
        if (x.getProperties().isEmpty()) {
            return false;
        }
        this.needsOpenBrace = true;
        this.needsComma = false;
        return true;
    }

    @Override
    public boolean visit(CssSelector x, Context ctx) {
        if (this.needsComma) {
            this.comma();
        }
        this.needsComma = true;
        this.out.print(x.getSelector());
        return true;
    }

    @Override
    public boolean visit(CssSprite x, Context ctx) {
        this.out.printOpt("/* CssSprite */");
        this.out.newlineOpt();
        this.addSubstitition(x);
        return false;
    }

    @Override
    public boolean visit(CssUrl x, Context ctx) {
        this.out.printOpt("/* CssUrl */");
        this.out.newlineOpt();
        return false;
    }

    private <T extends CssNode> void addSubstitition(T node) {
        if (this.substituteDots) {
            this.out.printOpt(".....");
            this.out.newlineOpt();
        } else {
            int position = this.out.toString().length();
            if (this.substitutionPositions.containsKey(position)) {
                ((List)this.substitutionPositions.get(position)).add(node);
            } else {
                ArrayList<T> nodes = new ArrayList<T>();
                nodes.add(node);
                this.substitutionPositions.put(position, nodes);
            }
        }
    }

    private void closeBrace() {
        this.out.indentOut();
        this.out.print('}');
        this.out.newlineOpt();
    }

    private void colon() {
        this.spaceOpt();
        this.out.print(':');
        this.spaceOpt();
    }

    private void comma() {
        this.out.print(',');
        this.spaceOpt();
    }

    private void important() {
        this.out.print(" !important");
    }

    private void openBrace() {
        this.spaceOpt();
        this.out.print('{');
        this.out.newlineOpt();
        this.out.indentIn();
    }

    private void semi() {
        this.out.print(';');
        this.out.newlineOpt();
    }

    private void spaceOpt() {
        this.out.printOpt(' ');
    }
}

