/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.util.Histogram;

public class DuplicationMetrics
extends MetricBase {
    public String LIBRARY;
    public long UNPAIRED_READS_EXAMINED;
    public long READ_PAIRS_EXAMINED;
    public long UNMAPPED_READS;
    public long UNPAIRED_READ_DUPLICATES;
    public long READ_PAIR_DUPLICATES;
    public long READ_PAIR_OPTICAL_DUPLICATES;
    public Double PERCENT_DUPLICATION;
    public Long ESTIMATED_LIBRARY_SIZE;

    public void calculateDerivedMetrics() {
        this.ESTIMATED_LIBRARY_SIZE = DuplicationMetrics.estimateLibrarySize(this.READ_PAIRS_EXAMINED - this.READ_PAIR_OPTICAL_DUPLICATES, this.READ_PAIRS_EXAMINED - this.READ_PAIR_DUPLICATES);
        this.PERCENT_DUPLICATION = (double)(this.UNPAIRED_READ_DUPLICATES + this.READ_PAIR_DUPLICATES * 2L) / (double)(this.UNPAIRED_READS_EXAMINED + this.READ_PAIRS_EXAMINED * 2L);
    }

    public static Long estimateLibrarySize(long readPairs, long uniqueReadPairs) {
        long readPairDuplicates = readPairs - uniqueReadPairs;
        if (readPairs > 0L && readPairDuplicates > 0L) {
            double r;
            double u;
            long n = readPairs;
            long c = uniqueReadPairs;
            double m = 1.0;
            double M = 100.0;
            if (c >= n || DuplicationMetrics.f(m * (double)c, c, n) < 0.0) {
                throw new IllegalStateException("Invalid values for pairs and unique pairs: " + n + ", " + c);
            }
            while (DuplicationMetrics.f(M * (double)c, c, n) >= 0.0) {
                M *= 10.0;
            }
            for (int i = 0; i < 40 && (u = DuplicationMetrics.f((r = (m + M) / 2.0) * (double)c, c, n)) != 0.0; ++i) {
                if (u > 0.0) {
                    m = r;
                    continue;
                }
                if (!(u < 0.0)) continue;
                M = r;
            }
            return (long)((double)c * (m + M) / 2.0);
        }
        return null;
    }

    private static double f(double x, double c, double n) {
        return c / x - 1.0 + Math.exp(-n / x);
    }

    public static double estimateRoi(long estimatedLibrarySize, double x, long pairs, long uniquePairs) {
        return (double)estimatedLibrarySize * (1.0 - Math.exp(-(x * (double)pairs) / (double)estimatedLibrarySize)) / (double)uniquePairs;
    }

    public Histogram<Double> calculateRoiHistogram() {
        if (this.ESTIMATED_LIBRARY_SIZE == null) {
            try {
                this.calculateDerivedMetrics();
                if (this.ESTIMATED_LIBRARY_SIZE == null) {
                    return null;
                }
            }
            catch (IllegalStateException ise) {
                return null;
            }
        }
        long uniquePairs = this.READ_PAIRS_EXAMINED - this.READ_PAIR_DUPLICATES;
        Histogram histo = new Histogram();
        for (double x = 1.0; x <= 100.0; x += 1.0) {
            histo.increment((Comparable)Double.valueOf(x), DuplicationMetrics.estimateRoi(this.ESTIMATED_LIBRARY_SIZE, x, this.READ_PAIRS_EXAMINED, uniquePairs));
        }
        return histo;
    }

    public static void main(String[] args) {
        DuplicationMetrics m = new DuplicationMetrics();
        m.READ_PAIRS_EXAMINED = Integer.parseInt(args[0]);
        m.READ_PAIR_DUPLICATES = Integer.parseInt(args[1]);
        m.calculateDerivedMetrics();
        System.out.println("Percent Duplication: " + m.PERCENT_DUPLICATION);
        System.out.println("Est. Library Size  : " + m.ESTIMATED_LIBRARY_SIZE);
        System.out.println();
        System.out.println("X Seq\tX Unique");
        for (Histogram.Bin bin : m.calculateRoiHistogram().values()) {
            System.out.println(bin.getId() + "\t" + bin.getValue());
        }
    }
}

