!{\src2tex{textfont=tt}}
!!****f* ABINIT/pawinit
!! NAME
!! pawinit
!!
!! FUNCTION
!! Initialize some starting values of several arrays used in
!! PAW calculations
!!
!! 1-Initialize data related to angular mesh
!! 2-Tabulate normalized shape function g(r)
!! 3-Compute indklmn indexes giving some l,m,n,lp,mp,np info
!!                           from klmn=[(l,m,n),(lp,mp,np)]
!! 4-Compute various factors/sizes (depending on (l,m,n))
!! 5-Compute $q_ijL=\displaystyle
!!                  \int_{0}^{r_c}{(\phi_i\phi_j-\widetilde{\phi_i}\widetilde{\phi_j}) r^l\,dr}
!!                   Gaunt(l_i m_i,l_j m_j,l m))$
!!           $S_ij=\displaystyle \sqrt{4 \pi} q_ij0$
!! 6-Compute $e_ijkl= vh1_ijkl - Vhatijkl - Bijkl - Cijkl$
!!     With:
!!       $vh1_ijkl =\sum_{L,m} {vh1*Gaunt(i,j,Lm)*Gaunt(k,l,Lm)}$
!!       $Vhat_ijkl=\sum_{L,m} {vhatijL*Gaunt(i,j,Lm)*q_klL}$
!!       $B_ijkl   =\sum_{L,m} {vhatijL*Gaunt(k,l,Lm)*q_ijL}$
!!       $C_ijkl   =\sum_{L,m} {intvhatL*q_ijL*q_klL}$
!!     and:
!!       vh1 according to eq. (A17) in Holzwarth et al., PRB 55, 2005 (1997)
!! 7-Compute Ex-correlation energy for the core density
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!  indlmn(6,i,ntypat)=array giving l,m,n,lm,ln,spin for i=lmn (for each atom type)
!!  lmix=max. l for which spherical terms will be mixed durinf SCF cycle
!!  lmnmax=max. number of (l,m,n) components over all type of psps
!!  mpsang=1+maximum angular momentum
!!  nphi="phi" dimension of paw angular mesh
!!  nsym=Number of symmetry elements in space group
!!  ntheta="theta" dimension of paw angular mesh
!!  ntypat=number of types of atoms in cell
!!  pawang <type(pawang_type)>=paw angular mesh and related data
!!     %lmax=Maximum value of angular momentum l+1
!!     %gntselect((2*l_max-1)**2,l_max**2,l_max**2)=
!!                     selection rules for Gaunt coefficients
!!  pawrad(ntypat) <type(pawrad_type)>=paw radial mesh and related data:
!!     %mesh_size=Dimension of radial mesh
!!     %rad(mesh_size)=The coordinates of all the points of the radial mesh
!!     %radfact(mesh_size)=Factor used to compute radial integrals
!!  pawtab(ntypat) <type(pawtab_type)>=paw tabulated starting data:
!!     %basis_size=Number of elements for the PAW nl basis
!!     %l_size=Maximum value of l+1 leading to non zero Gaunt coeffs
!!     %lmn_size=Number of (l,m,n) elements for the PAW basis
!!     %lmn2_size=lmn_size*(lmn_size+1)/2
!!     %dltij(lmn2_size)=factors used to compute sums over (ilmn,jlmn)
!!     %phi(mesh_size,basis_size)=PAW all electron wavefunctions
!!     %rshp=shape function radius (radius for compensation charge)
!!     %shape_type=Radial shape function type
!!     %shape_alpha=Alpha parameters in Bessel shape function
!!     %shape_lambda=Lambda parameter in gaussian shape function
!!     %shape_q=Q parameters in Bessel shape function
!!     %shape_sigma=Sigma parameter in gaussian shape function
!!     %tphi(mesh_size,basis_size)=PAW atomic pseudowavefunctions
!!  pawxcdev=Choice of XC development (0=no dev. (use of angular mesh) ; 1=dev. on moments)
!!
!! OUTPUT
!!  pawang
!!     %gntselect(l_size_max**2,l_max**2*(l_max**2+1)/2)=Selection rules for Gaunt coefficients
!!     %l_max=Maximum value of angular momentum l+1
!!     %l_size_max=Maximum value of angular momentum l_size=2*l_max-1
!!     %nsym=Number of symmetry elements in space group
!!     %ngnt=number of non-zero Gaunt coefficients
!!     %realgnt(pawang%ngnt)=non-zero real Gaunt coefficients
!!     === only if pawxcdev==1 ==
!!       %anginit(3,angl_size)=For each point of the angular mesh, gives the coordinates
!!                             of the corresponding point on an unitary sphere
!!       %angl_size=Dimension of paw angular mesh (angl_size=ntheta*nphi)
!!       %angwgth(angl_size)=For each point of the angular mesh, gives the weight
!!                           of the corresponding point on an unitary sphere
!!       %ntheta, nphi=Dimensions of paw angular mesh
!!       %ylmr(l_size_max**2,angl_size)=Real Ylm calculated in real space
!!  pawtab(ntypat) <type(pawtab_type)>=paw tabulated data read at start:
!!     %lmnmix_sz=number of (lmn,lmn_prime) verifying l<=lmix and l_prime<=lmix
!!     %indklmn(4,lmn2_size)=array giving klm, kln, abs(il-jl) and (il+jl) for each klmn=(ilmn,jlmn)
!!     %dshpfunc(mesh_size,l_size,4)=derivatives of shape function (used only for numerical shape functions)
!!     %eijkl(lmn2_size,lmn2_size)=Part of the Dij that depends only from the projected occupation coeffs
!!     %exccore=Exchange-correlation energy for the core density
!!     %gnorm(l_size)=Normalization factor of radial shape function
!!     %phiphj(:,:)=Useful product Phi(:,i)*Phi(:,j)
!!     %qijl(l_size**2,lmn2_size)=Moments of the difference charge density between AE and PS partial wave
!!     %rad_for_spline(mesh_size)=radial grid used for spline (copy of pawrad%rad)
!!     %shapefunc(mesh_size,l_size)=Normalized radial shape function
!!     %sij(lmn2_size)=Nonlocal part of the overlap operator
!!     %tphitphj(:,:)=Useful product tPhi(:,i)*tPhi(:,j)
!!
!! SIDE EFFECTS
!!  n1xccc=flag concerning the use of XC core-correction
!!     Input : always 1 (core-correction used by default)
!!     Output: according to tncore, 0=no core correction, 1=core correction used
!!
!! PARENTS
!!      gstate,respfn
!!
!! CHILDREN
!!      initang,initylmr,jbessel,leave_new,poisson,realgaunt,simp_gen,timab,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine pawinit(indlmn,lcutdens,lmix,lmnmax,mpsang,n1xccc,nphi,nsym,ntheta,ntypat,&
&                  pawang,pawrad,pawtab,pawxcdev)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_11util
 use interfaces_13paw, except_this_one => pawinit
#endif
!End of the abilint section

 implicit none

!Arguments ---------------------------------------------
!scalars
 integer,intent(in) :: lcutdens,lmix,lmnmax,mpsang,nphi,nsym,ntheta,ntypat,pawxcdev
 integer,intent(inout) :: n1xccc
 type(pawang_type),intent(inout) :: pawang
!arrays
 integer,intent(in) :: indlmn(6,lmnmax,ntypat)
 type(pawrad_type),intent(in) :: pawrad(ntypat)
 type(pawtab_type),intent(inout) :: pawtab(ntypat)

!Local variables ------------------------------
!scalars
 integer :: basis_size,i0lm,i0ln,ierr,il,ilm,ilmn,ilmn1,iln,ir,isel,isel1,ishp
 integer :: itypat,j0lm,j0lmn,j0lmn1,j0ln,j0ln1,jl,jlm,jlmn,jlmn1,jln,klm,klm1
 integer :: klmn,klmn1,kln,kln1,l_size,lambda,ll,lm0,lmax,lmax1,lmin,lmin1
 integer :: lmn2_size,lmn_size,lmnmix,mesh_size,mm,option,shape_type,usexcnhat
 real(dp) :: arg,argj1,argj2,argl,gnrm,intg,jbes1,jbes2,ql,ql1,rg,rg1,rshp
 real(dp) :: shapefunc1,shapefunc2,shapefunc3,sigma,vh1,xx,yp1,ypn
 character(len=500) :: message
!arrays
 integer :: indlmn_(6,lmnmax)
 integer,allocatable :: klm_diag(:),kmix_tmp(:)
 real(dp) :: alpha(2),qq(2),tsec(2)
 real(dp),allocatable :: dum(:),ff(:),gg(:),hh(:),indklmn_(:,:),intvhatl(:)
 real(dp),allocatable :: rad(:),rgnt_tmp(:),vhatijl(:,:),vhatl(:),work(:)
 real(dp),allocatable :: ylmrgr_dum(:,:,:)
!no_abirules
!Statement functions -----------------------------------
!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifndef HAVE_FORTRAN_INTERFACES
 real(dp) :: gaunt
 integer :: ifromr
#endif
!End of the abilint section

 shapefunc1(arg)= exp(-(arg/sigma)**lambda)
 shapefunc2(arg)= (sin(pi*arg/rshp)/(pi*arg/rshp))**2
 shapefunc3(argj1,argj2)= alpha(1)*argj1+alpha(2)*argj2

!***************************************************************************

!DEBUG
!write(6,*)' pawinit : enter'
!ENDDEBUG

!ENDDEBUG

 call timab(553,1,tsec)

!==================================================
!1- INITIALIZE DATA RELATED TO ANGULAR MESH
!   * ANGULAR GRID
!   * REAL SPHERICAL HARMONICS
!   * REAL GAUNT COEFFICIENTS

 pawang%nsym=nsym
 pawang%l_max=mpsang
 pawang%l_size_max=max(2*pawang%l_max-1,maxval(pawtab(:)%l_size))
 pawang%lcutd=lcutdens
 allocate(rgnt_tmp((2*pawang%l_max-1)**2*(pawang%l_max)**4))
 call realgaunt(pawang%l_max,pawang%ngnt,pawang%gntselect,rgnt_tmp)
 if (associated(pawang%realgnt)) deallocate(pawang%realgnt)
 allocate(pawang%realgnt(pawang%ngnt))
 pawang%realgnt(1:pawang%ngnt)=rgnt_tmp(1:pawang%ngnt)
 deallocate(rgnt_tmp)
 if (pawxcdev==0) then
  pawang%nphi=nphi
  pawang%ntheta=ntheta
  pawang%angl_size=nphi*ntheta
  allocate(pawang%anginit(3,pawang%angl_size))
  call initang(pawang)
  deallocate(pawang%anginit)
  option=1 ; allocate(ylmrgr_dum(1,1,0))
  call initylmr(pawang%l_size_max,0,pawang%angl_size,pawang%angwgth,&
&               option,pawang%anginit,pawang%ylmr,ylmrgr_dum)
  deallocate(ylmrgr_dum)
 end if

 n1xccc=0;usexcnhat=maxval(pawtab(1:ntypat)%vlocopt)

!*******************
!Loop on atom types
!*******************
 do itypat=1,ntypat
  mesh_size=pawrad(itypat)%mesh_size
  l_size=pawtab(itypat)%l_size
  shape_type=pawtab(itypat)%shape_type
  lmn_size=pawtab(itypat)%lmn_size
  lmn2_size=pawtab(itypat)%lmn2_size
  basis_size=pawtab(itypat)%basis_size
  indlmn_(:,:)=indlmn(:,:,itypat)
  allocate(indklmn_(4,lmn2_size),klm_diag(lmn2_size))
  allocate(ff(mesh_size),gg(mesh_size),hh(mesh_size),rad(mesh_size))
  rad(1:mesh_size)=pawrad(itypat)%rad(1:mesh_size)
  n1xccc=max(n1xccc,pawtab(itypat)%usetcore)

  if (pawtab(itypat)%vlocopt/=usexcnhat) then
   write(message, '(8a)' ) ch10,&
&   ' pawinit :  ERROR -',ch10,&
&   '   You cannot simultaneously use atomic data with different',ch10,&
&   '   formulation of local potential [Vbare or VH(tnzc)] !',ch10,&
&   '   Action: change at least one of your atomic data (psp) file.'
   call wrtout(6,message,'COLL')
   call leave_new('COLL')
  end if

!==================================================
!2- TABULATE SHAPE FUNCTION

  rshp=pawtab(itypat)%rshp;ishp=ifromr(pawrad(itypat),rshp)-1

! A-Analytic shape function N.k(r).r^l
! ------------------------------------
  if ((shape_type==1).or.(shape_type==2)) then
!  Select the suitable shape function
   ff(:)=zero;ff(1)=one
   if (shape_type==1) then
    sigma=pawtab(itypat)%shape_sigma;lambda=pawtab(itypat)%shape_lambda
    do ir=2,ishp
     ff(ir)=shapefunc1(rad(ir))
    end do
   else if (shape_type==2) then
    do ir=2,ishp
     ff(ir)=shapefunc2(rad(ir))
    end do
   end if
!  Compute Gnorm and store g(r)*gnorm*r**l in shapefunc
   pawtab(itypat)%gnorm(:)=zero
   do il=1,l_size
    gg(1)=zero;gg(2:mesh_size)=ff(2:mesh_size)*rad(2:mesh_size)**(2*il)
    call simp_gen(intg,gg,pawrad(itypat))
    gnrm=one/intg;pawtab(itypat)%gnorm(il)=gnrm
    if (il==1) then
     pawtab(itypat)%shapefunc(:,1)=gnrm*ff(:)
    else
     pawtab(itypat)%shapefunc(:,il)=gnrm*ff(:)*(rad(:)**(il-1))
    end if
   end do
  end if

! B-Analytic shape function Bessel form
! -------------------------------------
  if (shape_type==3) then
   do il=1,l_size
    alpha(1:2)=pawtab(itypat)%shape_alpha(1:2,il)
    qq(1:2)=pawtab(itypat)%shape_q(1:2,il)
    do ir=1,ishp
     call jbessel(jbes1,ql,ql1,il-1,0,qq(1)*rad(ir))
     call jbessel(jbes2,ql,ql1,il-1,0,qq(2)*rad(ir))
     pawtab(itypat)%shapefunc(ir,il)=shapefunc3(jbes1,jbes2)
    end do
    if (ishp<mesh_size) pawtab(itypat)%shapefunc(ishp+1:mesh_size,il)=zero
    pawtab(itypat)%gnorm(il)=one
   end do
  end if

! C-Numeric shape function
! -------------------------
  if ((shape_type==-1)) then
!  Assure normalization of shape function moments
   pawtab(itypat)%gnorm(:)=one
   do il=1,l_size
    ff(:)=pawtab(itypat)%shapefunc(:,il)*rad(:)**(il+1)
    call simp_gen(intg,ff,pawrad(itypat))
    pawtab(itypat)%shapefunc(:,il)=pawtab(itypat)%shapefunc(:,il)/intg
   end do
!  Compute some derivatives of shape function
   if (associated(pawtab(itypat)%dshpfunc)) deallocate(pawtab(itypat)%dshpfunc)
   allocate(pawtab(itypat)%dshpfunc(mesh_size,l_size,4))
   allocate(work(mesh_size))
   do il=1,l_size
    call nderiv_gen(pawtab(itypat)%dshpfunc(:,il,1),pawtab(itypat)%shapefunc(:,il),1,pawrad(itypat))
    yp1=pawtab(itypat)%dshpfunc(1,il,1);ypn=pawtab(itypat)%dshpfunc(mesh_size,il,1)
    call spline(rad,pawtab(itypat)%shapefunc(:,il),mesh_size,yp1,ypn,pawtab(itypat)%dshpfunc(:,il,2),work)
    yp1=pawtab(itypat)%dshpfunc(1,il,2);ypn=pawtab(itypat)%dshpfunc(mesh_size,il,2)
    call spline(rad,pawtab(itypat)%dshpfunc(:,il,1),mesh_size,yp1,ypn,pawtab(itypat)%dshpfunc(:,il,3),work)
    yp1=pawtab(itypat)%dshpfunc(1,il,3);ypn=pawtab(itypat)%dshpfunc(mesh_size,il,3)
    call spline(rad,pawtab(itypat)%dshpfunc(:,il,2),mesh_size,yp1,ypn,pawtab(itypat)%dshpfunc(:,il,4),work)
   end do
   deallocate(work)
  end if

! In some cases, has to store radial mesh in pawtab variable
  if ((shape_type==-1).or.pawtab(itypat)%usedvloc==1) then
   if (associated(pawtab(itypat)%rad_for_spline)) deallocate(pawtab(itypat)%rad_for_spline)
   allocate(pawtab(itypat)%rad_for_spline(mesh_size))
   pawtab(itypat)%rad_for_spline(1:mesh_size)=pawrad(itypat)%rad(1:mesh_size)
  end if

!==================================================
!3- COMPUTE indklmn INDEXES GIVING klm, kln, abs(il-jl) and (il+jl)
!                                  for each klmn=(ilmn,jlmn)

  klm_diag=0
  do jlmn=1,lmn_size
   jl= indlmn_(1,jlmn);jlm=indlmn_(4,jlmn);jln=indlmn_(5,jlmn)
   j0lmn=jlmn*(jlmn-1)/2
   j0lm =jlm *(jlm -1)/2
   j0ln =jln *(jln -1)/2
   do ilmn=1,jlmn
    il= indlmn_(1,ilmn);ilm=indlmn_(4,ilmn);iln=indlmn_(5,ilmn)
    klmn=j0lmn+ilmn
    if (ilm<=jlm) then
     indklmn_(1,klmn)=j0lm+ilm
    else
     i0lm=ilm*(ilm-1)/2
     indklmn_(1,klmn)=i0lm+jlm
    end if
    if (iln<=jln) then
     indklmn_(2,klmn)=j0ln+iln
    else
     i0ln=iln*(iln-1)/2
     indklmn_(2,klmn)=i0ln+jln
    end if
    indklmn_(3,klmn)=abs(il-jl)
    indklmn_(4,klmn)=il+jl
    pawtab(itypat)%indklmn(1:4,klmn)=indklmn_(1:4,klmn)
    if (ilm==jlm) klm_diag(klmn)=1
   end do
  end do

!==================================================
!4- COMPUTE various FACTORS/SIZES (depending on (l,m,n))

  pawtab(itypat)%dltij(:)=two
  do ilmn=1,lmn_size
   pawtab(itypat)%dltij(ilmn*(ilmn+1)/2)=one
  end do

  lmnmix=zero;allocate(kmix_tmp(lmn2_size))
  do jlmn=1,lmn_size
   jl=indlmn_(1,jlmn)
   if (jl<=lmix) then
    j0lmn=jlmn*(jlmn-1)/2
    do ilmn=1,jlmn
     il=indlmn_(1,ilmn)
     if (il<=lmix) then
      lmnmix=lmnmix+1
      kmix_tmp(lmnmix)=j0lmn+ilmn
     end if
    end do
   end if
  end do
  if (associated(pawtab(itypat)%kmix)) deallocate(pawtab(itypat)%kmix,STAT=ierr)  ! STAT= needed by some buggy compilers
  allocate(pawtab(itypat)%kmix(lmnmix))
  pawtab(itypat)%lmnmix_sz=lmnmix
  pawtab(itypat)%kmix(1:lmnmix)=kmix_tmp(1:lmnmix)
  deallocate(kmix_tmp)

!==================================================
!5- COMPUTE Qijl TERMS AND Sij MATRIX

! Store some usefull quantities
  do jln=1,basis_size
   j0ln=jln*(jln-1)/2
   do iln=1,jln
    kln=j0ln+iln
    pawtab(itypat)%phiphj  (1:mesh_size,kln)=pawtab(itypat)%phi (1:mesh_size,iln)&
&                                   *pawtab(itypat)%phi (1:mesh_size,jln)
    pawtab(itypat)%tphitphj(1:mesh_size,kln)=pawtab(itypat)%tphi(1:mesh_size,iln)&
&                                   *pawtab(itypat)%tphi(1:mesh_size,jln)
   end do
  end do

! Compute q_ijL and S_ij=q_ij0
  pawtab(itypat)%qijl=zero
  pawtab(itypat)%sij=zero
  do klmn=1,lmn2_size
   klm=indklmn_(1,klmn);kln=indklmn_(2,klmn)
   lmin=indklmn_(3,klmn);lmax=indklmn_(4,klmn)
   do ll=lmin,lmax,2
    lm0=ll*ll+ll+1;ff(1)=zero
    ff(2:mesh_size)=(pawtab(itypat)%phiphj  (2:mesh_size,kln)&
&                   -pawtab(itypat)%tphitphj(2:mesh_size,kln))&
&                   *rad(2:mesh_size)**ll
    call simp_gen(intg,ff,pawrad(itypat))
    do mm=-ll,ll
     isel=pawang%gntselect(lm0+mm,klm)
     if (isel>0) pawtab(itypat)%qijl(lm0+mm,klmn)=intg*pawang%realgnt(isel)
    end do
   end do
   if (klm_diag(klmn)==1) pawtab(itypat)%sij(klmn)= &
&                         pawtab(itypat)%qijl(1,klmn)*sqrt(four_pi)
  end do

!==================================================
!6- COMPUTE Eijkl TERMS

! Compute:
!   vhatL(r) according to eq. (A14) in Holzwarth et al., PRB 55, 2005 (1997)
!   intvhatL=$\int_{0}^{r_c}{vhatL(r) shapefunc_L(r) r^2\,dr}$
!   vhatijL =$\int_{0}^{r_c}{vhatL(r) \tilde{\phi}_i \tilde{\phi}_j \,dr}$
!  -----------------------------------------------------------------
  allocate(vhatl(mesh_size),vhatijl(lmn2_size,l_size),intvhatl(l_size))
  intvhatl(:)=zero;vhatl(:)=zero;vhatijl(:,:)=zero
  do il=1,l_size
   vhatl(1)=zero;ff(1)=zero
   ff(2:mesh_size)=pawtab(itypat)%shapefunc(2:mesh_size,il)&
&                 *rad(2:mesh_size)**2
   call poisson(ff,il-1,intg,pawrad(itypat),vhatl)
   vhatl(2:mesh_size)=vhatl(2:mesh_size)/rad(2:mesh_size)
   gg(1:mesh_size)=vhatl(1:mesh_size)*ff(1:mesh_size)
   call simp_gen(intvhatl(il),gg,pawrad(itypat))
   do klmn=1,lmn2_size
    kln=indklmn_(2,klmn)
    hh(1:mesh_size)=vhatl(1:mesh_size)*pawtab(itypat)%tphitphj(1:mesh_size,kln)
    call simp_gen(vhatijl(klmn,il),hh,pawrad(itypat))
   end do
  end do
  deallocate(vhatl)

! Compute:
!   eijkl=$ vh1_ijkl - Vhatijkl - Bijkl - Cijkl$
!     With:
!       $vh1_ijkl =\sum_{L,m} {vh1*Gaunt(i,j,Lm)*Gaunt(k,l,Lm)}$
!       $Vhat_ijkl=\sum_{L,m} {vhatijL*Gaunt(i,j,Lm)*q_klL}$
!       $B_ijkl   =\sum_{L,m} {vhatijL*Gaunt(k,l,Lm)*q_ijL}$
!       $C_ijkl   =\sum_{L,m} {intvhatL*q_ijL*q_klL}$
!     and:
!       vh1 according to eq. (A17) in Holzwarth et al., PRB 55, 2005 (1997)
!   Warning: compute only eijkl for (i,j)<=(k,l)
!  -----------------------------------------------------------------
  pawtab(itypat)%eijkl(:,:)=zero
  do klmn=1,lmn2_size
   klm=indklmn_(1,klmn);kln=indklmn_(2,klmn)
   lmin=indklmn_(3,klmn);lmax=indklmn_(4,klmn)
   do ll=lmin,lmax,2
    lm0=ll*ll+ll+1
    ff(:)=pawtab(itypat)%phiphj  (:,kln);call poisson(ff,ll,intg,pawrad(itypat),gg)
    ff(:)=pawtab(itypat)%tphitphj(:,kln);call poisson(ff,ll,intg,pawrad(itypat),hh)
    do klmn1=klmn,lmn2_size
     klm1=indklmn_(1,klmn1);kln1=indklmn_(2,klmn1)
     lmin1=indklmn_(3,klmn1);lmax1=indklmn_(4,klmn1)
     vh1=zero
     if ((ll.ge.lmin1).and.(ll.le.lmax1)) then
      ff(1)=zero
      ff(2:mesh_size)=(pawtab(itypat)%phiphj  (2:mesh_size,kln1)*gg(2:mesh_size)&
&                     -pawtab(itypat)%tphitphj(2:mesh_size,kln1)*hh(2:mesh_size))&
&                     /rad(2:mesh_size)
      call simp_gen(vh1,ff,pawrad(itypat))
     end if
     do mm=-ll,ll
      isel =pawang%gntselect(lm0+mm,klm)
      isel1=pawang%gntselect(lm0+mm,klm1)
      if (isel>0.and.isel1>0) then
       rg =pawang%realgnt(isel)
       rg1=pawang%realgnt(isel1)
       ql =pawtab(itypat)%qijl(lm0+mm,klmn)
       ql1=pawtab(itypat)%qijl(lm0+mm,klmn1)
       pawtab(itypat)%eijkl(klmn,klmn1)=pawtab(itypat)%eijkl(klmn,klmn1)&
&               +(   vh1                *rg *rg1&      ! vh1_ijkl
&               -    vhatijl(klmn ,ll+1)*rg *ql1&      ! Vhat_ijkl
&               -    vhatijl(klmn1,ll+1)*rg1*ql &      ! B_ijkl
&               -    intvhatl(ll+1)     *ql *ql1&      ! C_ijkl
&                )*two_pi
      end if
     end do
    end do
   end do
  end do
  deallocate(vhatijl,intvhatl)

!***********************
!End Loop on atom types
!***********************
  deallocate(ff,gg,hh,indklmn_,klm_diag,rad)
 end do

 call timab(553,2,tsec)

!DEBUG
!write(6,*)' pawinit : exit'
!ENDDEBUG

end subroutine pawinit
!!***
