//This file is part of AcetoneISO. Copyright 2006,2007,2008,2009 Marco Di Antonio and Fabrizio Di Marco (acetoneiso@gmail.com)
//
//    AcetoneISO is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    AcetoneISO is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with AcetoneISO.  If not, see <http://www.gnu.org/licenses/>.
#include "options.h"
#include"a_options.h"
//
optionsDiag::optionsDiag( QWidget * parent, Qt::WFlags f) 
	: QDialog(parent, f)
{

    setupUi(this);
    connect( pushButton_apply, SIGNAL( clicked() ), this, SLOT( update_options() ));
    connect( exit_button, SIGNAL( clicked() ), this, SLOT( update_options() ) );
    connect( exit_button, SIGNAL( clicked() ), this, SLOT( close() ) );
    connect( pushButton_defaults, SIGNAL( clicked() ), this, SLOT( setDefaults() ) );
    connect( database_button, SIGNAL( clicked() ), this, SLOT( getDbDir() ) );
    connect( pushButton_database, SIGNAL( clicked() ), this, SLOT( whatisdatabase() ) );

    connect(checkBox_2, SIGNAL(stateChanged(int) ), this, SLOT ( clickedtrayenable(int) )  );
    connect(checkBox, SIGNAL(stateChanged(int) ), this, SLOT ( recursivedb(int) )  );
    connect(checkBox_5, SIGNAL(stateChanged(int) ), this, SLOT ( cleanhistory(int) )  );
    
    
    //se esiste il file significa che l'utente ha cliccato in opzioni da database
    QDir Home = QDir::home();
    QFile advanced(Home.path() + "/.acetoneiso/optiondb.conf");
   if (advanced.exists()) {
      advanced.remove();
      toolBox->setCurrentIndex(3);  
    }   
     
optionss();
}


void optionsDiag::whatisdatabase() {
  
QMessageBox::information(this, "AcetoneISO",tr("Database is a quick and easy feature for managing your images.\nPlace them all in a folder and set the Database path to it, you will see all the images in the database display.\nYou can quickly mount them by simply clicking on them or right click for more options."));
}



void optionsDiag::clickedtrayenable(int stato) {

  //checkbox is unchecked
  if (stato == 0) {
    checkBox_4->setEnabled(false);
  }
  else {
     checkBox_4->setEnabled(true);
  }
  
}

void optionsDiag::recursivedb(int statodb) {
   //checkbox recursive is unchecked
  if (statodb == 0) {
    textBrowser->setEnabled(false);
  }
  else {
    textBrowser->setEnabled(true);
  } 
  
}

void optionsDiag::cleanhistory(int cleanh) {
   //checkbox clean history automatically is unchecked
  if (cleanh == 0) {
    checkBox_6->setEnabled(true);
  }
  else {
    checkBox_6->setEnabled(false);
  }   
}







