// ---------------------------------------------------------------------------
// - TlsServer.cpp                                                           -
// - afnix:tls service - tls server class implementation                     -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2015 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Vector.hpp"
#include "TlsServer.hpp"
#include "QuarkZone.hpp"
#include "Exception.hpp"
#include "TlsConnect.hpp"
#include "cnet.hpp"
#include "cerr.hpp"

namespace afnix {
 
  // -------------------------------------------------------------------------
  // - class section                                                         -
  // -------------------------------------------------------------------------

  // create a default tls server

  TlsServer::TlsServer (void) {
  }

  // create a server by name and host

  TlsServer::TlsServer (const String& host, t_word port) : 
    TcpServer (host, port) {
  }
  
  // return the class name
  
  String TlsServer::repr (void) const {
    return "TlsServer";
  }

  // get an accepted connected socket

  TcpSocket* TlsServer::accept (void) const {
    rdlock ();
    TlsState* ssta = nilp;
    try {
      // get the accepted socket
      TcpSocket* s = TcpSocket::accept ();
      // create a tls connect
      TlsConnect tc (true);
      // connect the socket
      ssta = tc.connect (s, s);
      // create the result socket
      TcpSocket* result = new TlsSocket (s, ssta);
      unlock ();
      return result;
    } catch (...) {
      delete ssta;
      unlock ();
      throw;
    }
  }

  // -------------------------------------------------------------------------
  // - object section                                                        -
  // -------------------------------------------------------------------------

  // create a new object in a generic way

  Object* TlsServer::mknew (Vector* argv) {
    // get the number of arguments
    long argc = (argv == nilp) ? 0 : argv->length ();
    
    // check for 0 argument
    if (argc == 0) return new TlsServer;
    // check for 2 arguments
    if (argc == 2) {
      String host = argv->getstring (0);
      t_word port = argv->getlong   (1);
      return new TlsServer (host, port);
    }
    // too many arguments
    throw Exception ("argument-error", 
                     "too many argument with tls server constructor");
  }
}
