/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-editor-line-mode.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-editor-line-mode
 * @title: IAnjutaEditorLineMode
 * @short_description: Text editor line mode
 * @see_also:
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-editor-line-mode.h
 *
 */

#include "ianjuta-editor-line-mode.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_editor_line_mode_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-editor-line-mode-quark");
	}
	
	return quark;
}

/**
 * ianjuta_editor_line_mode_convert:
 * @obj: Self
 * @mode: Line mode to convert.
 * @err: Error propagation and reporting
 *
 * Set the line ending mode to the given @mode and convert all line end
 * characters in the buffer to @mode line end characters.
 */
void
ianjuta_editor_line_mode_convert (IAnjutaEditorLineMode *obj, IAnjutaEditorLineModeType mode, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_LINE_MODE(obj));
	IANJUTA_EDITOR_LINE_MODE_GET_IFACE (obj)->convert (obj, mode, err);
}

/* Default implementation */
static void
ianjuta_editor_line_mode_convert_default (IAnjutaEditorLineMode *obj, IAnjutaEditorLineModeType mode, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_editor_line_mode_fix:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Convert EOL characters to majority of line mode. This is helpful
 * when the buffer contains mixed line modes and we want to fix it.
 */
void
ianjuta_editor_line_mode_fix (IAnjutaEditorLineMode *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_LINE_MODE(obj));
	IANJUTA_EDITOR_LINE_MODE_GET_IFACE (obj)->fix (obj, err);
}

/* Default implementation */
static void
ianjuta_editor_line_mode_fix_default (IAnjutaEditorLineMode *obj, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_editor_line_mode_get:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Get current line ending mode. It is auto-detected from the
 * buffer contents.
 */
IAnjutaEditorLineModeType
ianjuta_editor_line_mode_get (IAnjutaEditorLineMode *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR_LINE_MODE(obj), 0);
	return IANJUTA_EDITOR_LINE_MODE_GET_IFACE (obj)->get (obj, err);
}

/* Default implementation */
static IAnjutaEditorLineModeType
ianjuta_editor_line_mode_get_default (IAnjutaEditorLineMode *obj, GError **err)
{
	g_return_val_if_reached (0);
}

/**
 * ianjuta_editor_line_mode_set:
 * @obj: Self
 * @mode: Line mode to set.
 * @err: Error propagation and reporting
 *
 * Set the line ending mode to the given @mode. Existing line end
 * characters in the buffer are not touched. Only the newly added
 * texts will have @mode line end characters.
 */
void
ianjuta_editor_line_mode_set (IAnjutaEditorLineMode *obj, IAnjutaEditorLineModeType mode, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_LINE_MODE(obj));
	IANJUTA_EDITOR_LINE_MODE_GET_IFACE (obj)->set (obj, mode, err);
}

/* Default implementation */
static void
ianjuta_editor_line_mode_set_default (IAnjutaEditorLineMode *obj, IAnjutaEditorLineModeType mode, GError **err)
{
	g_return_if_reached ();
}

static void
ianjuta_editor_line_mode_base_init (IAnjutaEditorLineModeIface* klass)
{
	static gboolean initialized = FALSE;

	klass->convert = ianjuta_editor_line_mode_convert_default;
	klass->fix = ianjuta_editor_line_mode_fix_default;
	klass->get = ianjuta_editor_line_mode_get_default;
	klass->set = ianjuta_editor_line_mode_set_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_editor_line_mode_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaEditorLineModeIface),
			(GBaseInitFunc) ianjuta_editor_line_mode_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaEditorLineMode", &info, 0);
		g_type_interface_add_prerequisite (type, IANJUTA_TYPE_EDITOR);
	}
	return type;			
}

GType
ianjuta_editor_line_mode_type_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_EDITOR_LINE_MODE_LF, "IANJUTA_EDITOR_LINE_MODE_LF", "lf" }, 
		{ IANJUTA_EDITOR_LINE_MODE_CR, "IANJUTA_EDITOR_LINE_MODE_CR", "cr" }, 
		{ IANJUTA_EDITOR_LINE_MODE_CRLF, "IANJUTA_EDITOR_LINE_MODE_CRLF", "crlf" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaEditorLineModeType", values);
	}

	return type;
}
