/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 15:42:23 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.datatransfer.Clipboard;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.FeaturePatternPredicate;
import uk.ac.sanger.artemis.FilteredEntryGroup;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.io.BlastEntryInformation;
import uk.ac.sanger.artemis.io.ChadoCanonicalGene;
import uk.ac.sanger.artemis.io.DatabaseInferredFeature;
import uk.ac.sanger.artemis.io.DatabaseStreamFeature;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.GFFStreamFeature;
import uk.ac.sanger.artemis.io.GenbankStreamFeature;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RangeVector;
import uk.ac.sanger.artemis.io.ValidateFeature;
import uk.ac.sanger.artemis.sequence.AminoAcidSequence;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class ValidateFeature_ESTest extends ValidateFeature_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      // Undeclared exception!
      try { 
        ValidateFeature.validateGO((QualifierVector) null, blastEntryInformation0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.ValidateFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      // Undeclared exception!
      try { 
        ValidateFeature.testHeader((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.io.StringReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      // Undeclared exception!
      try { 
        ValidateFeature.isStrandOK((GFFStreamFeature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.ValidateFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      // Undeclared exception!
      try { 
        ValidateFeature.isPartialConsistent((GFFStreamFeature) null, "evidence=");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.ValidateFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      // Undeclared exception!
      try { 
        ValidateFeature.isPartOfGene((GFFStreamFeature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.ValidateFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeaturePatternPredicate featurePatternPredicate0 = new FeaturePatternPredicate((AminoAcidSequence) null);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featurePatternPredicate0, "Ontology_term");
      ValidateFeature validateFeature0 = new ValidateFeature(filteredEntryGroup0);
      // Undeclared exception!
      try { 
        validateFeature0.isInternalStops((Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.ValidateFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      // Undeclared exception!
      try { 
        ValidateFeature.isIdPrefixConsistent((GFFStreamFeature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.ValidateFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      // Undeclared exception!
      try { 
        ValidateFeature.isCompleteGeneModelOK((GFFStreamFeature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.ValidateFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      // Undeclared exception!
      try { 
        ValidateFeature.isCDSPhaseOK((GFFStreamFeature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.ValidateFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      // Undeclared exception!
      try { 
        ValidateFeature.isBoundaryOK((GFFStreamFeature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.ValidateFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      // Undeclared exception!
      try { 
        ValidateFeature.isAttributesOK((GFFStreamFeature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.ValidateFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      Key key0 = Key.CDS;
      Range range0 = new Range(16000);
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, true);
      QualifierVector qualifierVector0 = new QualifierVector();
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      boolean boolean0 = ValidateFeature.isPartOfGene(gFFStreamFeature0);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      Key key0 = new Key("Start_range");
      Range range0 = new Range(4);
      Location location0 = new Location(range0);
      QualifierVector qualifierVector0 = new QualifierVector();
      DatabaseStreamFeature databaseStreamFeature0 = new DatabaseStreamFeature(key0, location0, qualifierVector0);
      ValidateFeature.isPartOfGene(databaseStreamFeature0);
      boolean boolean0 = ValidateFeature.isPartOfGene(databaseStreamFeature0);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      Key key0 = Key.CDS;
      Range range0 = new Range(942, 942);
      Location location0 = new Location(range0);
      QualifierVector qualifierVector0 = new QualifierVector();
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      DatabaseInferredFeature databaseInferredFeature0 = new DatabaseInferredFeature(key0, location0, qualifierVector0, chadoCanonicalGene0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Clipboard clipboard0 = new Clipboard("VNisc+}$XR{=");
      Selection selection0 = new Selection(clipboard0);
      uk.ac.sanger.artemis.FeatureVector featureVector0 = selection0.getAllFeatures();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "VNisc+}$XR{=");
      ValidateFeature validateFeature0 = new ValidateFeature(filteredEntryGroup0);
      boolean boolean0 = validateFeature0.hasValidStop(databaseInferredFeature0);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      Key key0 = Key.CDS;
      Range range0 = new Range(16000);
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, true);
      QualifierVector qualifierVector0 = new QualifierVector();
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      ValidateFeature validateFeature0 = new ValidateFeature((EntryGroup) null);
      boolean boolean0 = validateFeature0.isInternalStops(gFFStreamFeature0);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      Key key0 = Key.CDS;
      Range range0 = new Range(16000);
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, true);
      QualifierVector qualifierVector0 = new QualifierVector();
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      String string0 = ValidateFeature.isAttributesOK(gFFStreamFeature0);
      assertEquals("", string0);
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      Key key0 = new Key("Start_range");
      Range range0 = new Range(4);
      Location location0 = new Location(range0);
      QualifierVector qualifierVector0 = new QualifierVector();
      DatabaseStreamFeature databaseStreamFeature0 = new DatabaseStreamFeature(key0, location0, qualifierVector0);
      boolean boolean0 = ValidateFeature.isCDSPhaseOK(databaseStreamFeature0);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      Key key0 = Key.CDS;
      Range range0 = new Range((-360));
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, true);
      QualifierVector qualifierVector0 = new QualifierVector();
      DatabaseInferredFeature databaseInferredFeature0 = new DatabaseInferredFeature(key0, location0, qualifierVector0, (ChadoCanonicalGene) null);
      boolean boolean0 = ValidateFeature.isCDSPhaseOK(databaseInferredFeature0);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      Key key0 = Key.CDS;
      Range range0 = new Range((-360));
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, true);
      QualifierVector qualifierVector0 = new QualifierVector();
      DatabaseInferredFeature databaseInferredFeature0 = new DatabaseInferredFeature(key0, location0, qualifierVector0, (ChadoCanonicalGene) null);
      boolean boolean0 = ValidateFeature.isIdPrefixConsistent(databaseInferredFeature0);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      Key key0 = Key.CDS;
      Range range0 = new Range(942, 942);
      Location location0 = new Location(range0);
      QualifierVector qualifierVector0 = new QualifierVector();
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      DatabaseInferredFeature databaseInferredFeature0 = new DatabaseInferredFeature(key0, location0, qualifierVector0, chadoCanonicalGene0);
      boolean boolean0 = ValidateFeature.isIdPrefixConsistent(databaseInferredFeature0);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      DatabaseStreamFeature databaseStreamFeature0 = new DatabaseStreamFeature(genbankStreamFeature0);
      boolean boolean0 = ValidateFeature.isPartialConsistent(databaseStreamFeature0, "Start_range");
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      Key key0 = Key.CDS;
      Range range0 = new Range(942, 942);
      Location location0 = new Location(range0);
      QualifierVector qualifierVector0 = new QualifierVector();
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      DatabaseInferredFeature databaseInferredFeature0 = new DatabaseInferredFeature(key0, location0, qualifierVector0, chadoCanonicalGene0);
      boolean boolean0 = ValidateFeature.isStrandOK(databaseInferredFeature0);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      DatabaseStreamFeature databaseStreamFeature0 = new DatabaseStreamFeature(genbankStreamFeature0);
      boolean boolean0 = ValidateFeature.isStrandOK(databaseStreamFeature0);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      Key key0 = Key.CDS;
      Range range0 = new Range(942, 942);
      Location location0 = new Location(range0);
      QualifierVector qualifierVector0 = new QualifierVector();
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      DatabaseInferredFeature databaseInferredFeature0 = new DatabaseInferredFeature(key0, location0, qualifierVector0, chadoCanonicalGene0);
      int int0 = ValidateFeature.isBoundaryOK(databaseInferredFeature0);
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      Key key0 = Key.CDS;
      Range range0 = new Range(11);
      Location location0 = new Location(range0);
      QualifierVector qualifierVector0 = new QualifierVector();
      DatabaseStreamFeature databaseStreamFeature0 = new DatabaseStreamFeature(key0, location0, qualifierVector0);
      int int0 = ValidateFeature.isBoundaryOK(databaseStreamFeature0);
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      Key key0 = Key.CDS;
      Range range0 = new Range(16000);
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, true);
      QualifierVector qualifierVector0 = new QualifierVector();
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      int int0 = ValidateFeature.isCompleteGeneModelOK(gFFStreamFeature0);
      assertEquals(1, int0);
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      QualifierVector qualifierVector0 = new QualifierVector();
      String string0 = ValidateFeature.validateGO(qualifierVector0, (EntryInformation) null);
      assertEquals("", string0);
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      boolean boolean0 = ValidateFeature.isGFF((Feature) null, (EntryGroup) null);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      uk.ac.sanger.artemis.FeatureVector featureVector0 = new uk.ac.sanger.artemis.FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "zwzS)0m&p");
      boolean boolean0 = ValidateFeature.isGFF((Feature) null, filteredEntryGroup0);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      Key key0 = Key.CDS;
      Range range0 = new Range(16000);
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, true);
      QualifierVector qualifierVector0 = new QualifierVector();
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      boolean boolean0 = ValidateFeature.isGFF(gFFStreamFeature0, (EntryGroup) null);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      ValidateFeature.testHeader("VNisc+}$XR{=");
  }
}
