/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:30:11 GMT 2018
 */

package uk.ac.sanger.artemis.sequence;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import javax.swing.JLayeredPane;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.PartialSequence;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.plot.AGWindowAlgorithm;
import uk.ac.sanger.artemis.sequence.AminoAcidSequence;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.SequenceChangeListener;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class Bases_ESTest extends Bases_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("PL");
      Bases bases0 = new Bases(genbankStreamSequence0);
      bases0.toString();
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      char[] charArray0 = new char[0];
      Bases.reverseComplement(charArray0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      Bases.reverseComplement("");
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("<iVjbM({(+mG:", "I&4*F6h{T^Qa#p");
      Bases bases0 = new Bases(fastaStreamSequence0);
      bases0.getLength();
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("", "");
      Bases bases0 = new Bases(fastaStreamSequence0);
      bases0.getGCount();
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      char[] charArray0 = new char[2];
      Short short0 = new Short((short) (-1387));
      Integer integer0 = JLayeredPane.FRAME_CONTENT_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 3411, 885, short0, integer0);
      Bases bases0 = new Bases(partialSequence0);
      bases0.getAverageAGPercent();
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      // Undeclared exception!
      try { 
        Bases.reverseComplement((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("u");
      Bases bases0 = new Bases(rawStreamSequence0);
      Range range0 = new Range(0);
      // Undeclared exception!
      try { 
        bases0.deleteRange(range0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -1
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      // Undeclared exception!
      try { 
        Bases.complement((char[]) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      // Undeclared exception!
      try { 
        Bases.complement((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      Bases.complement('f');
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      Bases.complement('N');
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      Bases.complement('Q');
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      Bases.complement('&');
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      Bases.complement('C');
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      Bases.complement('x');
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      Bases.complement('d');
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      Bases.complement('V');
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      bases0.addSequenceChangeListener((SequenceChangeListener) null, 0);
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      char[] charArray0 = new char[2];
      Integer integer0 = JLayeredPane.PALETTE_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 0, 0, (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      bases0.getLength();
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("PL");
      Bases bases0 = new Bases(genbankStreamSequence0);
      bases0.getForwardStrand();
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      Bases.isLegalBase('c');
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      Bases.isLegalBase('d');
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      char[] charArray0 = new char[3];
      charArray0[1] = 'y';
      Bases.complement(charArray0);
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      char[] charArray0 = new char[5];
      charArray0[0] = 'l';
      Bases.complement(charArray0);
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      char[] charArray0 = new char[6];
      charArray0[1] = 'D';
      char[] charArray1 = Bases.reverseComplement(charArray0);
      Bases.complement(charArray1);
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      Bases.complement('b');
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      char[] charArray0 = new char[5];
      charArray0[2] = '_';
      Bases.complement(charArray0);
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      char[] charArray0 = new char[7];
      charArray0[6] = '^';
      Bases.reverseComplement(charArray0);
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      Bases.complement(']');
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      char[] charArray0 = new char[6];
      charArray0[3] = '[';
      Bases.complement(charArray0);
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      char[] charArray0 = new char[9];
      charArray0[2] = 'Z';
      Bases.complement(charArray0);
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      char[] charArray0 = new char[6];
      charArray0[0] = 'Y';
      Bases.complement(charArray0);
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      char[] charArray0 = new char[6];
      charArray0[1] = 'X';
      Bases.complement(charArray0);
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      char[] charArray0 = new char[6];
      charArray0[4] = 'U';
      Bases.reverseComplement(charArray0);
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      Bases.complement("=$*QJ;TF+8@1");
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      Bases.complement("fixedStep");
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      char[] charArray0 = new char[5];
      charArray0[1] = 'R';
      Bases.reverseComplement(charArray0);
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      char[] charArray0 = new char[3];
      charArray0[2] = 'O';
      Bases.complement(charArray0);
  }

  @Test(timeout = 4000)
  public void test39()  throws Throwable  {
      Bases.reverseComplement("vij0#%Mz%Kn&/`P");
  }

  @Test(timeout = 4000)
  public void test40()  throws Throwable  {
      Bases.reverseComplement("GjQ|..W");
  }

  @Test(timeout = 4000)
  public void test41()  throws Throwable  {
      Bases.reverseComplement("EF0>Lw}DV>");
  }

  @Test(timeout = 4000)
  public void test42()  throws Throwable  {
      char[] charArray0 = new char[6];
      charArray0[5] = 'B';
      Bases.reverseComplement(charArray0);
  }

  @Test(timeout = 4000)
  public void test43()  throws Throwable  {
      char[] charArray0 = new char[2];
      Short short0 = new Short((short) (-1387));
      Integer integer0 = JLayeredPane.FRAME_CONTENT_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 3411, 885, short0, integer0);
      Bases bases0 = new Bases(partialSequence0);
      Bases.complement(bases0.letter_index);
  }

  @Test(timeout = 4000)
  public void test44()  throws Throwable  {
      Bases.complement("E,o5\"");
  }

  @Test(timeout = 4000)
  public void test45()  throws Throwable  {
      Bases.complement("");
  }

  @Test(timeout = 4000)
  public void test46()  throws Throwable  {
      Bases.reverseComplement("uk.ac.sanger.artemis.io.LocationParseNode");
  }

  @Test(timeout = 4000)
  public void test47()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("<iVjbM({(+mG:", "I&4*F6h{T^Qa#p");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Range range0 = new Range(1);
      simpleEntryGroup0.truncate(range0);
  }

  @Test(timeout = 4000)
  public void test48()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("Can't create a SimpleDistributionTrainer for non-finite alphabet ");
      Bases bases0 = new Bases(emblStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Range range0 = new Range((-1361), 2114);
      // Undeclared exception!
      simpleEntryGroup0.truncate(range0);
  }

  @Test(timeout = 4000)
  public void test49()  throws Throwable  {
      char[] charArray0 = new char[2];
      Short short0 = new Short((short) (-1387));
      Integer integer0 = JLayeredPane.FRAME_CONTENT_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 3411, 885, short0, integer0);
      Bases bases0 = new Bases(partialSequence0);
      Range range0 = new Range((-5), 0);
      Bases bases1 = bases0.truncate(range0);
      assertEquals((-5), Bases.MIN_PRIORITY);
  }

  @Test(timeout = 4000)
  public void test50()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("]i'xJoo?vZ]mQFeZI");
      Bases bases0 = new Bases(rawStreamSequence0);
      // Undeclared exception!
      try { 
        bases0.getSubSequence((Range) null, 0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test51()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("PL");
      Bases bases0 = new Bases(genbankStreamSequence0);
      int int0 = bases0.getRawPosition(588, 1);
      assertEquals(588, int0);
  }

  @Test(timeout = 4000)
  public void test52()  throws Throwable  {
      char[] charArray0 = new char[2];
      Short short0 = new Short((short) (-1387));
      Integer integer0 = JLayeredPane.FRAME_CONTENT_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 3411, 885, short0, integer0);
      Bases bases0 = new Bases(partialSequence0);
      int int0 = bases0.getRawPosition((-1224), (-3220));
      assertEquals(4636, int0);
  }

  @Test(timeout = 4000)
  public void test53()  throws Throwable  {
      int int0 = Bases.getIndexOfBase('&');
      assertEquals(4, int0);
  }

  @Test(timeout = 4000)
  public void test54()  throws Throwable  {
      char[] charArray0 = new char[2];
      Short short0 = new Short((short) (-1387));
      Integer integer0 = JLayeredPane.FRAME_CONTENT_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 3411, 885, short0, integer0);
      Bases bases0 = new Bases(partialSequence0);
      int int0 = bases0.getACount();
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test55()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Range range0 = new Range(0);
      // Undeclared exception!
      try { 
        bases0.truncate(range0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test56()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      // Undeclared exception!
      try { 
        bases0.getAverageGCPercent();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test57()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("mixed-stranded");
      Bases bases0 = new Bases(rawStreamSequence0);
      bases0.clearCodonCache();
      assertEquals(2, Bases.REVERSE);
  }

  @Test(timeout = 4000)
  public void test58()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      // Undeclared exception!
      try { 
        bases0.getAverageAGPercent();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test59()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
  }

  @Test(timeout = 4000)
  public void test60()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      // Undeclared exception!
      try { 
        bases0.toString();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test61()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("");
      Bases bases0 = new Bases(emblStreamSequence0);
      // Undeclared exception!
      try { 
        bases0.getSpacedTranslation((Range) null, 2195, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test62()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("A8>");
      Bases bases0 = new Bases(genbankStreamSequence0);
      int int0 = bases0.getCCount();
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test63()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("7q4/L?D");
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence(genbankStreamSequence0);
      Bases bases0 = new Bases(rawStreamSequence0);
      bases0.reverseComplement();
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(7, rawStreamSequence0.getOtherCount());
  }

  @Test(timeout = 4000)
  public void test64()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Range range0 = new Range((-1697));
      // Undeclared exception!
      try { 
        bases0.deleteRange(range0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test65()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("j':[/N'!fBvSb");
      Bases bases0 = new Bases(fastaStreamSequence0);
      int int0 = bases0.getTCount();
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test66()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      // Undeclared exception!
      try { 
        bases0.getGCount();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test67()  throws Throwable  {
      char[] charArray0 = new char[2];
      Short short0 = new Short((short) (-1387));
      Integer integer0 = JLayeredPane.FRAME_CONTENT_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 3411, 885, short0, integer0);
      Bases bases0 = new Bases(partialSequence0);
      Range range0 = new Range((-5), 0);
      AminoAcidSequence aminoAcidSequence0 = bases0.getTranslation(range0, 99, false);
      assertEquals("..", aminoAcidSequence0.toString());
  }
}
