Setup

  $ source "$TESTDIR"/_setup.sh

Node-data JSONs produced from a different major version of augur
are not allowed.

  $ ${AUGUR} export v2 \
  >   --tree "$TESTDIR/../data/tree.nwk" \
  >   --node-data "$TESTDIR/../data/div_node-data.json" "$TESTDIR/../data/location_node-data2.json" \
  >   --auspice-config "$TESTDIR/../data/auspice_config3.json" \
  >   --output dataset.json
  ERROR: Augur version incompatibility detected: the JSON .*location_node-data2\.json.* was generated by \{'program': 'augur', 'version': '13.1.2'\}, which is incompatible with the current augur version \([.0-9]+\). We suggest you rerun the pipeline using the current version of augur. (re)
  [2]

Skipping validation allows mismatched augur versions to be used without error.
(Note the stderr/stdout output is detailed here, including 2 empty lines)

  $ ${AUGUR} export v2 \
  >   --tree "$TESTDIR/../data/tree.nwk" \
  >   --node-data "$TESTDIR/../data/div_node-data.json" "$TESTDIR/../data/location_node-data2.json" \
  >   --auspice-config "$TESTDIR/../data/auspice_config2.json" \
  >   --output dataset.json \
  >   --skip-validation
  WARNING: You didn't provide information on who is maintaining this analysis.
  \s{0} (re)
  Skipping validation of produced JSON due to --validation-mode=skip or --skip-validation.
  \s{0} (re)

Check the output from the above command against its expected contents

  $ python3 "$TESTDIR/../../../../scripts/diff_jsons.py"  "$TESTDIR/../data/dataset2.json" dataset.json \
  >   --exclude-paths "root['meta']['updated']"
  {}
