/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef PICKEDPIXELMAP_H
#define PICKEDPIXELMAP_H

#include <QWidget>
#include <qvector3d.h>

#include "MultiPickingAPI.h"
#include "ImageComponent.h"

/**
 * This class is dedicated to manage an ImageComponent with a list of selected/picked pixels.
 * This class allows to manage a generic list of pixels too (add, remove, modify and save some points).
 */
class MULTIPICKING_API PickedPixelMap {

public:
  /// constructor
  PickedPixelMap (camitk::ImageComponent*);

  /// destructor
  virtual ~PickedPixelMap();

  /** Allows to remove one pixel in the list
   * @param id the index in the list of the pixel to remove
   */
  void removePixel (int id);

  /** Allows to modify one pixel in the list
   * @param row the index in the list of the pixel to modify using the last picked pixel
   */
  void modifyPixel (int row);

  /// Allows to add a pixel in the list using the last picked pixel
  void addPixel();

  /** save the list of pixel in a given file base name (CSV format, separator = comma).
   *  ".csv" is automatically added if needed.
   * the format is : index (int) , i (int) , j (int) , k (int) , x (double) , y (double) , z (double)
   * @param fileName the location where the file will be saved
   */
  void savePixelList (QString fileName);

  /** open a list of pixel in a given file base name (CSV format, separator = comma).
   *  the format is : index (int) , i (int) , j (int) , k (int) , x (double) , y (double) , z (double)
   **/
  void openPixelList (QString fileName);

  /// return the list of pixel index
  QList<QVector3D>* getPixelIndexList();

  /// return the list of coordinates pixel index
  QList<QVector3D>* getCoordIndexList();

  /// return the liste of pixel values
  QList<double> * getPixelValueList();

  /// the managed ImageComponent
  camitk::ImageComponent* getImage();

  /// Empties the pixel list.
  void resetPixelList();

  /// Change pixel list (copy the one given in parameters)
  void changePixelIndexList(QList<QVector3D> * liste);

  /// Change pixel list from a list of real coordinates
  void changePixelIndexListFromRealCoordinates(QList<QVector3D> * listeOfRealCoords);


private:

  /** conversion pixel index to coordinates
   * @param i the first index pixel to retrieve x in coordinate
   * @param j the second index pixel to retrieve y in coordinate
   * @param k the third index pixel to retrieve z in coordinate
   */
  QVector3D convertIndexToCoordinates (int i, int j, int k);

  /** conversion pixel index to coordinates
   * @param x 
   * @param y 
   * @param z 
   */
  QVector3D convertCoordinatesToIndex (double x, double y, double z);

  /// this is a list of pixels (as i,j,k indexes in the 3 directions)
  QList<QVector3D> *pixelIndexList;

  /// ImageComponent where the pixels are clicked
  camitk::ImageComponent *image;

};

#endif // PICKEDPIXELMAP_H
