#!/usr/bin/python
# Copyright 2008, Google Inc.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
#     * Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above
# copyright notice, this list of conditions and the following disclaimer
# in the documentation and/or other materials provided with the
# distribution.
#     * Neither the name of Google Inc. nor the names of its
# contributors may be used to endorse or promote products derived from
# this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


"""
This tool generates bad NaCl modules that should never be generated by
a conformant compiler.  These bad modules are used to test that
sel_ldr correctly detects that these are bad modules.

"""

import sys

EHDR_SIZE=52
EI_ABIVERSION_OFFSET=8  # eventually take over set_abi_version?

PHDR_SIZE=32
P_MEMSZ_OFF=(5*4)
PT_LOAD=1
PT_PHDR=6


FILE_MODIFICATIONS=[
    [ "fib_scalar.nexe", "integer_overflow_while_madvising.nexe",
      [ ( EHDR_SIZE + PHDR_SIZE + P_MEMSZ_OFF + 3, chr(0xbf)),
        ]
      ],
    [ "fib_scalar.nexe", "negative_hole.nexe",
      [ ( EHDR_SIZE + PHDR_SIZE + P_MEMSZ_OFF + 3, chr(0xf)),
        ],
      ],
    [ "fib_scalar.nexe", "text_too_big.nexe",
      [ ( EHDR_SIZE + PHDR_SIZE + P_MEMSZ_OFF + 3, chr(0x5f)),
        ],
      ],
    ]


def UpdateData(data, change_list):
  for ix, replacement_byte in change_list:
    data = data[:ix] + replacement_byte + data[ix+1:]
  return data


def UpdateFileWithChangeList(src_file, dst_file, change_list):
  data = open(src_file).read()
  data = UpdateData(data, change_list)
  open(dst_file, 'w').write(data)

if __name__ == '__main__':
  for src_file, dst_file, cl in FILE_MODIFICATIONS:
    UpdateFileWithChangeList(src_file, dst_file, cl)
  sys.exit(0)
