<?php
/*
+--------------------------------------------------------------------+
| CiviCRM version 4.7                                                |
+--------------------------------------------------------------------+
| Copyright CiviCRM LLC (c) 2004-2017                                |
+--------------------------------------------------------------------+
| This file is a part of CiviCRM.                                    |
|                                                                    |
| CiviCRM is free software; you can copy, modify, and distribute it  |
| under the terms of the GNU Affero General Public License           |
| Version 3, 19 November 2007 and the CiviCRM Licensing Exception.   |
|                                                                    |
| CiviCRM is distributed in the hope that it will be useful, but     |
| WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               |
| See the GNU Affero General Public License for more details.        |
|                                                                    |
| You should have received a copy of the GNU Affero General Public   |
| License and the CiviCRM Licensing Exception along                  |
| with this program; if not, contact CiviCRM LLC                     |
| at info[AT]civicrm[DOT]org. If you have questions about the        |
| GNU Affero General Public License or the licensing of CiviCRM,     |
| see the CiviCRM license FAQ at http://civicrm.org/licensing        |
+--------------------------------------------------------------------+
*/
/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2017
 *
 * Generated from xml/schema/CRM/Core/Job.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:ec2775b0ba09eb61d32f1565ebbaf4f8)
 */
require_once 'CRM/Core/DAO.php';
require_once 'CRM/Utils/Type.php';
/**
 * CRM_Core_DAO_Job constructor.
 */
class CRM_Core_DAO_Job extends CRM_Core_DAO {
  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  static $_tableName = 'civicrm_job';
  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var boolean
   */
  static $_log = false;
  /**
   * Job Id
   *
   * @var int unsigned
   */
  public $id;
  /**
   * Which Domain is this scheduled job for
   *
   * @var int unsigned
   */
  public $domain_id;
  /**
   * Scheduled job run frequency.
   *
   * @var string
   */
  public $run_frequency;
  /**
   * When was this cron entry last run
   *
   * @var timestamp
   */
  public $last_run;
  /**
   * When is this cron entry scheduled to run
   *
   * @var timestamp
   */
  public $scheduled_run_date;
  /**
   * Title of the job
   *
   * @var string
   */
  public $name;
  /**
   * Description of the job
   *
   * @var string
   */
  public $description;
  /**
   * Entity of the job api call
   *
   * @var string
   */
  public $api_entity;
  /**
   * Action of the job api call
   *
   * @var string
   */
  public $api_action;
  /**
   * List of parameters to the command.
   *
   * @var text
   */
  public $parameters;
  /**
   * Is this job active?
   *
   * @var boolean
   */
  public $is_active;
  /**
   * Class constructor.
   */
  function __construct() {
    $this->__table = 'civicrm_job';
    parent::__construct();
  }
  /**
   * Returns foreign keys and entity references.
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  static function getReferenceColumns() {
    if (!isset(Civi::$statics[__CLASS__]['links'])) {
      Civi::$statics[__CLASS__]['links'] = static ::createReferenceColumns(__CLASS__);
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'domain_id', 'civicrm_domain', 'id');
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'links_callback', Civi::$statics[__CLASS__]['links']);
    }
    return Civi::$statics[__CLASS__]['links'];
  }
  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = array(
        'id' => array(
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Job ID') ,
          'description' => 'Job Id',
          'required' => true,
          'table_name' => 'civicrm_job',
          'entity' => 'Job',
          'bao' => 'CRM_Core_BAO_Job',
          'localizable' => 0,
        ) ,
        'domain_id' => array(
          'name' => 'domain_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Job Domain') ,
          'description' => 'Which Domain is this scheduled job for',
          'required' => true,
          'table_name' => 'civicrm_job',
          'entity' => 'Job',
          'bao' => 'CRM_Core_BAO_Job',
          'localizable' => 0,
          'FKClassName' => 'CRM_Core_DAO_Domain',
          'pseudoconstant' => array(
            'table' => 'civicrm_domain',
            'keyColumn' => 'id',
            'labelColumn' => 'name',
          )
        ) ,
        'run_frequency' => array(
          'name' => 'run_frequency',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Job Frequency') ,
          'description' => 'Scheduled job run frequency.',
          'maxlength' => 8,
          'size' => CRM_Utils_Type::EIGHT,
          'default' => 'Daily',
          'table_name' => 'civicrm_job',
          'entity' => 'Job',
          'bao' => 'CRM_Core_BAO_Job',
          'localizable' => 0,
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'callback' => 'CRM_Core_SelectValues::getJobFrequency',
          )
        ) ,
        'last_run' => array(
          'name' => 'last_run',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => ts('Last Run') ,
          'description' => 'When was this cron entry last run',
          'required' => false,
          'default' => 'NULL',
          'table_name' => 'civicrm_job',
          'entity' => 'Job',
          'bao' => 'CRM_Core_BAO_Job',
          'localizable' => 0,
        ) ,
        'scheduled_run_date' => array(
          'name' => 'scheduled_run_date',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => ts('Scheduled Run Date') ,
          'description' => 'When is this cron entry scheduled to run',
          'required' => false,
          'default' => 'NULL',
          'table_name' => 'civicrm_job',
          'entity' => 'Job',
          'bao' => 'CRM_Core_BAO_Job',
          'localizable' => 0,
        ) ,
        'name' => array(
          'name' => 'name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Job Name') ,
          'description' => 'Title of the job',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_job',
          'entity' => 'Job',
          'bao' => 'CRM_Core_BAO_Job',
          'localizable' => 0,
        ) ,
        'description' => array(
          'name' => 'description',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Job Description') ,
          'description' => 'Description of the job',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_job',
          'entity' => 'Job',
          'bao' => 'CRM_Core_BAO_Job',
          'localizable' => 0,
        ) ,
        'api_entity' => array(
          'name' => 'api_entity',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('API Entity') ,
          'description' => 'Entity of the job api call',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_job',
          'entity' => 'Job',
          'bao' => 'CRM_Core_BAO_Job',
          'localizable' => 0,
        ) ,
        'api_action' => array(
          'name' => 'api_action',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('API Action') ,
          'description' => 'Action of the job api call',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_job',
          'entity' => 'Job',
          'bao' => 'CRM_Core_BAO_Job',
          'localizable' => 0,
        ) ,
        'parameters' => array(
          'name' => 'parameters',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('API Parameters') ,
          'description' => 'List of parameters to the command.',
          'rows' => 4,
          'cols' => 60,
          'table_name' => 'civicrm_job',
          'entity' => 'Job',
          'bao' => 'CRM_Core_BAO_Job',
          'localizable' => 0,
          'html' => array(
            'type' => 'TextArea',
          ) ,
        ) ,
        'is_active' => array(
          'name' => 'is_active',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Job Is Active?') ,
          'description' => 'Is this job active?',
          'table_name' => 'civicrm_job',
          'entity' => 'Job',
          'bao' => 'CRM_Core_BAO_Job',
          'localizable' => 0,
        ) ,
      );
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }
  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }
  /**
   * Returns the names of this table
   *
   * @return string
   */
  static function getTableName() {
    return self::$_tableName;
  }
  /**
   * Returns if this table needs to be logged
   *
   * @return boolean
   */
  function getLog() {
    return self::$_log;
  }
  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &import($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'job', $prefix, array());
    return $r;
  }
  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &export($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'job', $prefix, array());
    return $r;
  }
  /**
   * Returns the list of indices
   */
  public static function indices($localize = TRUE) {
    $indices = array();
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }
}
