# CiviCRM 5.27.0

Released July 1, 2020

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| **Require attention to configuration options?**                 | **yes** |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Warn users who lack PHP-Intl extension (Work Towards
  [dev/translation#48](https://lab.civicrm.org/dev/translation/-/issues/48):
  [17668](https://github.com/civicrm/civicrm-core/pull/17668), [17728](https://github.com/civicrm/civicrm-core/pull/17728))**

  A system check warning will now appear on sites that lack the PHP
  Internationalization extension.  This is in preparation for changes that will
  appear in CiviCRM 5.28 and require the extension.

- **Advanced Search - Allow searching by first/last name; pass values from
  quicksearch ([dev/core#1722](https://lab.civicrm.org/dev/core/-/issues/1722):
  [17118](https://github.com/civicrm/civicrm-core/pull/17118))**

  This makes separate First Name and Last Name fields available on the Advanced
  Search form, and it ensures quick search filters are passed to the appropriate
  field.

- **Add more search options
  ([17372](https://github.com/civicrm/civicrm-core/pull/17372))**

  Improves the search form for individuals in contact reference fields by adding
  fields for Employer Name, First Name, Last Name, and Nick Name.

- **End of life planning for MySQL server 5.0 - 5.6
  ([dev/core#1681](https://lab.civicrm.org/dev/core/-/issues/1681):
  [17518](https://github.com/civicrm/civicrm-core/pull/17518) and
  [17496](https://github.com/civicrm/civicrm-core/pull/17496))**

  Sites running MySQL 5.5 and below will have a pre-upgrade message and a system
  check warning to say that CiviCRM 5.28 will require MySQL 5.6 or MariaDB 10.1.

- **APIv4 - Improve pseudoconstant suffix support
  ([17368](https://github.com/civicrm/civicrm-core/pull/17368) and
  [17482](https://github.com/civicrm/civicrm-core/pull/17482))**

  APIv4 allows pseudoconstant fields to be specified with the pseudoconstant
  name followed by a suffix, such as `activity_type_id:label`.  This now works
  for retrieval and sort.

- **APIv4 - Support custom entity joins
  ([17394](https://github.com/civicrm/civicrm-core/pull/17394))**

  Improves APIv4 so that it supports implicit and explicit joins onto custom
  entities.

- **Make reCAPTCHA settings clearer
  ([17426](https://github.com/civicrm/civicrm-core/pull/17426))**

  The help text for reCAPTCHA settings now specifies the type of reCAPTCHA
  supported.

- **Configurable logfile size and hashing
  ([17192](https://github.com/civicrm/civicrm-core/pull/17192))**

  Allows a system administrator to give logs a predictable name, allowing them
  to be more easily ingested into other tools, and be handled by external log
  rotation tools.

- **Allow for installation on Symfony 4.4
  ([17380](https://github.com/civicrm/civicrm-core/pull/17380))**

  Makes it so CiviCRM plays nicely with Symfony 4.4.

- **Add domain tokens to the Message Template admin interface
  ([17388](https://github.com/civicrm/civicrm-core/pull/17388))**

  This adds the domain tokens (the domain organization name, address, email, and
  phone) to the available listed tokens for editing message templates.

- **Hide icon elements from screen readers and add handling for
  screen-reader-only text
  ([17318](https://github.com/civicrm/civicrm-core/pull/17318),
  [17293](https://github.com/civicrm/civicrm-core/pull/17293),
  [17294](https://github.com/civicrm/civicrm-core/pull/17294), and
  [17310](https://github.com/civicrm/civicrm-core/pull/17310))**

  CiviCRM uses empty `<i>` elements to provide most icons.  Screen readers,
  which won't render the visual icon anyway, will either skip over an empty
  element or announce it in a way that would be confusing.  This makes it
  explicit that screen readers and other ARIA devices should skip them.

  Meanwhile, if the icon is the only way a piece of information is displayed, a
  screen reader user won't get that information.  This adds a `sr-only` class
  that makes the element invisible on screen without being ignored by a screen
  reader.

  Screen reader text is added for the field option wrench icons, relationship
  permissions, and membership auto-renew status.

- **Add icon helper functions and remove most uses of check.gif
  ([17279](https://github.com/civicrm/civicrm-core/pull/17279) and
  [17289](https://github.com/civicrm/civicrm-core/pull/17289))**

  This adds helper functions in PHP and Smarty to render consistent icons with a
  minimum of code.  It also replaces most instances of the green checkmark image
  with a checkmark icon.

- **Separate icon markup from labels and add JS icon helper
  ([17319](https://github.com/civicrm/civicrm-core/pull/17319) and
  [17285](https://github.com/civicrm/civicrm-core/pull/17285))**

  These changes improve `CRM_Core_Action::formLink()`, `hook_civicrm_links`, and
  certain listing pages so that HTML icon markup is added at the point of
  display rather than during the processing of values.

  It also adds a helper function in Javascript similar to those in PHP and
  Smarty to render icons.

- **crmButton: Support icon=0 for no icon
  ([17303](https://github.com/civicrm/civicrm-core/pull/17303))**

  Makes it possible to create a button without an icon using {crmButton}.

- **Replace stop-icon.png with fa-ban over a relevant icon for privacy
  ([17283](https://github.com/civicrm/civicrm-core/pull/17283) and
  [17307](https://github.com/civicrm/civicrm-core/pull/17307))**

  The communication preference icons are standardized and more specific than the
  old stop sign.

- **Replace image icons with Font Awesome icons
  ([17296]([17280](https://github.com/civicrm/civicrm-core/pull/17280),
  [17281](https://github.com/civicrm/civicrm-core/pull/17281),
  [17282](https://github.com/civicrm/civicrm-core/pull/17282),
  [17295](https://github.com/civicrm/civicrm-core/pull/17295),
  https://github.com/civicrm/civicrm-core/pull/17296),
  [17297](https://github.com/civicrm/civicrm-core/pull/17297))**

  Nearly all image icons have been replaced with the corresponding icons from
  the Font Awesome library.

- **Simplify admin console and remove superfluous icons
  ([17284](https://github.com/civicrm/civicrm-core/pull/17284))**

  The Administration console has been redesigned to have a simpler layout,
  display more information, dynamically include all enabled components, display
  responsively on small screens, and remove a slew of 15-year-old image icons.

- **Dedupe performance - hard-remove financial_item from list of dymnamic  refs
  to contact table
  ([17567](https://github.com/civicrm/civicrm-core/pull/17567))**

  This improves performance when deduping by no longer querying the financial
  item table.

- **Trigger fatalErrorHandler for PEAR errors and for logs with severity ERROR
  or higher ([17277](https://github.com/civicrm/civicrm-core/pull/17277))**

  This allows extensions that implement `$config->fatalErrorHandler` to react to
  a wider variety of errors that CiviCRM may generate.

### CiviContribute

- **Wrap separators in price field in spans with classes
  ([dev/user-interface#18](https://lab.civicrm.org/dev/user-interface/-/issues/18):
  [17078](https://github.com/civicrm/civicrm-core/pull/17078))**

  Colons separating pre- and post-field help text from price fields are now
  wrapped in `<span>` elements.

- **Allow to search on contribution ID
  ([dev/core#1580](https://lab.civicrm.org/dev/core/-/issues/1580):
  [16484](https://github.com/civicrm/civicrm-core/pull/16484))**

  This improves the "Find Contributions" search form by adding a field to search
  by Contribution ID.

- **APIv4 - Add "Price"-related entities
  ([17363](https://github.com/civicrm/civicrm-core/pull/17363))**

  Priceset, PriceField, and PriceOption entities are added to APIv4.

- **APIv4 - Add ContributionRecur entity
  ([17299](https://github.com/civicrm/civicrm-core/pull/17299))**

  Adds Contribution Recur to APIv4.

### CiviMail

- **Allow click-through and open tracking to be enabled/disabled by default
  ([17291](https://github.com/civicrm/civicrm-core/pull/17291))**

  Adds a setting to CiviMail which allows for setting the click-through and open
  tracking defaults.

- **Extend content array of hook_civicrm_alterMailContent
  ([dev/core#1620](https://lab.civicrm.org/dev/core/-/issues/1620):
  [16629](https://github.com/civicrm/civicrm-core/pull/16629))**

  Adds campaign_id to template for `alterMailContent` hook.

- **Migrate CiviMail "extern" scripts to conventional routes
  ([17312](https://github.com/civicrm/civicrm-core/pull/17312))**

  Updates CiviMail's default behavior to replace `extern/open.php` and
  `extern/url.php` with `civicrm/mailing/open` and `civicrm/mailing/url`.

- **Make `is_archived` work as a url-search parameter
  ([17328](https://github.com/civicrm/civicrm-core/pull/17328))**

  The Find Mailings URL can now have `is_archived` as a parameter to only find
  archived mailings.

### CiviMember

- **Add MembershipType to Api4
  ([17448](https://github.com/civicrm/civicrm-core/pull/17448))**

  Adds a Membership Type entity to APIv4.

### Drupal Integration

- **CiviCRM menu toggle "adjust menu position" customisable
  ([dev/core#1757](https://lab.civicrm.org/dev/core/-/issues/1757):
  [17362](https://github.com/civicrm/civicrm-core/pull/17362))**

  This hides the "adjust menu position" icon in the CiviCRM Menu for non admin
  users to avoid confusion for users who do not have access to the Drupal admin
  menu.

- **Provide "Calendar" module with an end-date when a duration is provided
  ([601](https://github.com/civicrm/civicrm-drupal/pull/601))**

  Improves display of activities in calendar views.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **CRM_Utils_Time::setTime and getTime() and their use in unit tests
  ([dev/core#1781](https://lab.civicrm.org/dev/core/-/issues/1781):
  [17414](https://github.com/civicrm/civicrm-core/pull/17414))**

  This allows the CRM_Utils_Time functions used in unit tests to use TIME_FUNC
  to better isolate timing bugs.

- **Confusing popups when importing activities
  ([dev/user-interface#17](https://lab.civicrm.org/dev/user-interface/-/issues/17):
  [17067](https://github.com/civicrm/civicrm-core/pull/17067))**

  This fixes a bug where the confirmation popup would appear when hitting the
  back/cancel buttons, not just the import button, on most import forms.

- **Installing CiviCRM in another language, with civicrm-setup
  ([dev/translation#39](https://lab.civicrm.org/dev/translation/-/issues/39):
  [17244](https://github.com/civicrm/civicrm-core/pull/17244))**

  Fixes a bug when installing CiviCRM in another language with civicrm-setup.

- **Replace all instances of CRM_Core_Fatal with throw new CRM_Core_Exception
  ([dev/core#560](https://lab.civicrm.org/dev/core/-/issues/560):
  [17421](https://github.com/civicrm/civicrm-core/pull/17421),
  [17343](https://github.com/civicrm/civicrm-core/pull/17343),
  [17336](https://github.com/civicrm/civicrm-core/pull/17336) and
  [17341](https://github.com/civicrm/civicrm-core/pull/17341))**

- **CiviCRM 5.13.4 - smart groups with contact subtypes: subtype is not in
  Contact Type field on edit criteria mode
  ([dev/core#991](https://lab.civicrm.org/dev/core/-/issues/991):
  [16541](https://github.com/civicrm/civicrm-core/pull/16541))**

  Fixes contact subtypes not being carried over when editing a smart group
  created in Advanced Search.

- **Unable to import relationship
  ([dev/core#1731](https://lab.civicrm.org/dev/core/-/issues/1731):
  [17163](https://github.com/civicrm/civicrm-core/pull/17163))**

  Ensures that importing relationships works as expected when the same field is
  to be imported for the main imported contact and a related contact.

- **Apostrophes in richtext fields don't get exported properly in CiviReport
  ([dev/core#1743](https://lab.civicrm.org/dev/core/-/issues/1743):
  [17260](https://github.com/civicrm/civicrm-core/pull/17260))**

- **Statically added members of a smart group are not found
  ([dev/core#1745](https://lab.civicrm.org/dev/core/-/issues/1745):
  [17419](https://github.com/civicrm/civicrm-core/pull/17419))**

- **Deleting an activity with attachments doesn't delete the file or entries in
  civicrm_file/civicrm_entity_file
  ([dev/core#1753](https://lab.civicrm.org/dev/core/-/issues/1753):
  [17298](https://github.com/civicrm/civicrm-core/pull/17298))**

- **Deselected checkbox settings are not saved
  ([dev/core#1794](https://lab.civicrm.org/dev/core/-/issues/1794):
  [17493](https://github.com/civicrm/civicrm-core/pull/17493))**

  Ensures deselected values are saved on custom field settings forms.

- **Added activity types don't appear in the type dropdown on New Activity
  ([dev/core#1822](https://lab.civicrm.org/dev/core/-/issues/1822):
  [17625](https://github.com/civicrm/civicrm-core/pull/17625))**

- **API doesn't allow passing option values by label
  ([dev/core#1816](https://lab.civicrm.org/dev/core/-/issues/1816):
  [17628](https://github.com/civicrm/civicrm-core/pull/17628))**

  Updates APIv4 so that it matches based on label if name is not found.

- **APIv4 - Improve custom field spec gathering
  ([17471](https://github.com/civicrm/civicrm-core/pull/17471))**

- **APIv4 - Remove implicit multi joins & add explicit joins
 ([17332](https://github.com/civicrm/civicrm-core/pull/17332))**

- **APIv4 - Fix entity name on custom groups in schemaMapper
  ([17425](https://github.com/civicrm/civicrm-core/pull/17425))**

- **APIv4 - fix returning custom field values with API4
  ([17399](https://github.com/civicrm/civicrm-core/pull/17399))**

- **Attempting to access Multi-Record Custom Field import results
  in crash
  ([dev/core#1841](https://lab.civicrm.org/dev/core/-/issues/1841):
  [17713](https://github.com/civicrm/civicrm-core/pull/17713))**

- **Fix issue with building smart groups when $contactQueries is empty
  ([17622](https://github.com/civicrm/civicrm-core/pull/17622))**

  If a clause of a contact query used to build a smart group is empty, it would
  result in a database error.

- **Replace deprecated `money_format()` fn to support PHP 7.4
  (Work Towards [dev/core#1494](https://lab.civicrm.org/dev/core/-/issues/1494):
  [17577](https://github.com/civicrm/civicrm-core/pull/17577), [17730](https://github.com/civicrm/civicrm-core/pull/17730))**

  Adds a deprecation notice and a status check for a money value format
  configuration other than the default.

- **QueueTest - Be more forgiving about slow execution
  ([17532](https://github.com/civicrm/civicrm-core/pull/17532))**

- **CommunityMessages - Define more consistent behavior in the face of slow
  execution ([17529](https://github.com/civicrm/civicrm-core/pull/17529))**

  This helps avoid test failures on broadcast messages when the system is
  running slowly.

- **Scheduled Reminders - Set boolean fields to false if not set.
  ([17494](https://github.com/civicrm/civicrm-core/pull/17494))**

- **Allow bidirectional assignment of relationships from search results
  ([17413](https://github.com/civicrm/civicrm-core/pull/17413))**

  Previously relationships could only be created from search results where the
  contacts would be valid in the "A" side of the relationship type.

- **Navigation menu - Fix translation of new-subtype entries
  ([17451](https://github.com/civicrm/civicrm-core/pull/17451))**

  The "New" in menu items for creating a new contact of a subtype was not
  translated.

- **utf8mb4 - If strict mode enabled query will fail if KEY_BLOCK_SIZE is not 0
  ([17253](https://github.com/civicrm/civicrm-core/pull/17253))**

- **Update DAO and l10n schema file
  ([17395](https://github.com/civicrm/civicrm-core/pull/17395))**

  Price option name and value are now required in the database.

- **Fix adding languages in multilingual
  ([17228](https://github.com/civicrm/civicrm-core/pull/17228))**

  This resolves a database error when adding or removing a language on a
  multilingual site.

- **Don't exclude deleted contacts from ACL cache when user has permission
  ([17379](https://github.com/civicrm/civicrm-core/pull/17379))**

- **SMTP page appears broken when language is French (JS issue)
  ([dev/core#1760](https://lab.civicrm.org/dev/core/-/issues/1760):
  [17317](https://github.com/civicrm/civicrm-core/pull/17317))**

  Javascript strings that appear in Smarty are now escaped more thoroughly to
  avoid markup problems.

- **Add serialize column to civicrm_custom_field, remove "Multi-Select" html
  type ([16992](https://github.com/civicrm/civicrm-core/pull/16992), [17722](https://github.com/civicrm/civicrm-core/pull/17722))**

  Work towards making custom select and multi-select fields more similar to
  core select/multi-select fields.

- **Respect file fields that have been configured as view only in profiles
  ([17079](https://github.com/civicrm/civicrm-core/pull/17079))**

- **Tag create - Respect created_date and created_id params
  ([17257](https://github.com/civicrm/civicrm-core/pull/17257))**

- **Public status messages should show correct class/icon like error
  ([17376](https://github.com/civicrm/civicrm-core/pull/17376))**

- **Decorative chevrons should be icons not angle quotes
  ([17245](https://github.com/civicrm/civicrm-core/pull/17245))**

- **A/B Test - Icon should be Erlenmeyer flask, not bar chart
  ([17316](https://github.com/civicrm/civicrm-core/pull/17316))**

- **Proceeding to confirmation page should be a "next" button not a check
  ([17246](https://github.com/civicrm/civicrm-core/pull/17246))**

### CiviCase

- **Case Activity: Follow-up activity assignee does not receive email
  ([dev/core#1721](https://lab.civicrm.org/dev/core/-/issues/1721):
  [17116](https://github.com/civicrm/civicrm-core/pull/17116))**

  Ensures when a follow up case activity is created the assignee is sent an
  email.

### CiviContribute

- **Custom fields disappear on page refresh
  ([dev/core#1728](https://lab.civicrm.org/dev/core/-/issues/1728):
  [17301](https://github.com/civicrm/civicrm-core/pull/17301))**

  This ensures that financial type specific custom fields are displayed on the
  backend contribution form when it is refreshed.

- **Fix pricefield pseudoconstant.
  ([17364](https://github.com/civicrm/civicrm-core/pull/17364))**

  Fixes `PriceField` entity to build options for the `price_set_id`
  pseudoconstant field.

- **Nuance cancel options for processors
  ([17430](https://github.com/civicrm/civicrm-core/pull/17430))**

  This allows payment processors to specify the way they allow cancellation of
  recurring contributions.

- **[regression] Contribution amount choices don't appear for anonymous users
  ([dev/core#1823](https://lab.civicrm.org/dev/core/-/issues/1823):
  [17619](https://github.com/civicrm/civicrm-core/pull/17619))**

- **Import Contribution of custom fields only accepts "Numeric Value" rather
  than "Label" ([dev/core#1806](https://lab.civicrm.org/dev/core/-/issues/1806):
  [17632](https://github.com/civicrm/civicrm-core/pull/17632))**

- **"Financial Type" listed twice in contribution export
  ([dev/core#1650](https://lab.civicrm.org/dev/core/-/issues/1650):
  [17147](https://github.com/civicrm/civicrm-core/pull/17147))**

- **Record Payment does not update check_number & trxn id on main contribution.
  ([dev/core#1758](https://lab.civicrm.org/dev/core/-/issues/1758):
  [17314](https://github.com/civicrm/civicrm-core/pull/17314))**

- **civicrm_financial_trxn.fee_amount reversals mixed up
  ([dev/core#1775](https://lab.civicrm.org/dev/core/-/issues/1775):
  [17386](https://github.com/civicrm/civicrm-core/pull/17386))**

- **jquery validation type error on the credit card field
  ([dev/core#1797](https://lab.civicrm.org/dev/core/-/issues/1797):
  [17497](https://github.com/civicrm/civicrm-core/pull/17497))**

  Fixes a jQuery error when submitting a front end contribution form with a
  credit card field.

- **Fix payment instrument bug by using correct payment instrument
  ([17607](https://github.com/civicrm/civicrm-core/pull/17607))**

  When a backend payment form records a payment it now will use a
  processor-specific default payment instrument rather than the site-wide
  default if it is set.

- **Payment PropertyBag - Fix setAmount
  ([17505](https://github.com/civicrm/civicrm-core/pull/17505))**

  Ensures "Amount" is set correctly on PropertyBag.

- **Fixed hide show of start date
  ([17446](https://github.com/civicrm/civicrm-core/pull/17446))**

  Fix hide/show of receive date for recurring contributions.

- **Don't allow Contribution.repeattransaction to be used without a recurring
  contribution ([17447](https://github.com/civicrm/civicrm-core/pull/17447))**

- **Add actual field name for processor_id to getSubscriptionDetails
  ([17466](https://github.com/civicrm/civicrm-core/pull/17466))**

- **Make 'Pending' the default status for Contribution.repeattransaction
  ([17432](https://github.com/civicrm/civicrm-core/pull/17432))**

- **Fetch line items from correct contribution when repeating a contribution
  ([17220](https://github.com/civicrm/civicrm-core/pull/17220))**

- **Support order_reference param in API3 Payment.create
  ([17278](https://github.com/civicrm/civicrm-core/pull/17278))**

- **E_WARNINGS when viewing list of pledge payments
  ([dev/core#1791](https://lab.civicrm.org/dev/core/-/issues/1791):
  [17434](https://github.com/civicrm/civicrm-core/pull/17434))**

- **Add propertyBag handling for getEmail when incoming uses email-5
  ([17267](https://github.com/civicrm/civicrm-core/pull/17267))**

  Payment processors can now retrieve billing email using the `propertyBag`
  class methods.

### CiviMail

- **Don't log subscription_history
  ([dev/core#1762](https://lab.civicrm.org/dev/core/-/issues/1762):
  [17323](https://github.com/civicrm/civicrm-core/pull/17323))**

  The `civicrm_subscription_history` table is effectively a log of contacts
  being added to and removed from groups.  Rows do not change value; each change
  in group subscription results in a new row.  Consequently, there is no reason
  to attach detailed logging to this table.

- **Unsubscribe generates 500 server error responses, logs say "missing
  parameters" ([dev/core#1773](https://lab.civicrm.org/dev/core/-/issues/1773):
  [17402](https://github.com/civicrm/civicrm-core/pull/17402))**

  Ensures the unsubscribe form can only be submitted once.

### CiviMember

- **Recurring contribution fails with "ipn_payment_callback_exception", for
  membership auto-renewal via PayPalPro.
  ([dev/core#1608](https://lab.civicrm.org/dev/core/-/issues/1608):
  [17355](https://github.com/civicrm/civicrm-core/pull/17355))**

- **Don't hide disabled memberships from the contact membership tab
  ([dev/membership#24](https://lab.civicrm.org/dev/membership/-/issues/24):
  [17143](https://github.com/civicrm/civicrm-core/pull/17143) and
  [17435](https://github.com/civicrm/civicrm-core/pull/17435))**

  This resolves a problem where memberships of disabled membership types would
  not appear on the membership tab but would throw a duplicate membership
  warning when creating a new membership with the same membership organization.
  This also adds a unit test to lock in the correct behavior.

- **Update MembershipType.name to be a required field
  ([17463](https://github.com/civicrm/civicrm-core/pull/17463))**

- **Fix PHP notice when is_override is not set
  ([17273](https://github.com/civicrm/civicrm-core/pull/17273))**

### Joomla Integration

- **Upgrade from 5.26.2 to 5.27 RC Fails
  ([dev/joomla/#28](https://lab.civicrm.org/dev/joomla/-/issues/28):
  [17710](https://github.com/civicrm/civicrm-core/pull/17710))**

### WordPress Integration

- **Styling issues after upgrade to WordPress 5.3
  ([dev/wordpress#46](https://lab.civicrm.org/dev/wordpress/-/issues/46):
  [16967](https://github.com/civicrm/civicrm-core/pull/16967))**

- **WP - Change definitions of `cms.root`, `civicrm.root`
  ([17360](https://github.com/civicrm/civicrm-core/pull/17360))**

  The base logic for computing path/URL defaults is in Civi/Core/Paths.php.

  For CiviCRM on WordPress, certain variables (which are easier to compute via
  WordPress APIs) are overridden in `CRM_Utils_System_WordPress`.

  On WordPress, the path/URL logic for has been split: there is one code path
  for normal CiviCRM pages which is based on WordPress APIs, and there is
  another for older, standalone scripts in the `extern` folder which is based on
  the same logic as before.

- **Declare minimum WP and PHP versions required for installation
  ([201](https://github.com/civicrm/civicrm-wordpress/pull/201))**

- **wp-rest - Adjust extern URL. Be more defensive about 'query' part.
  ([192](https://github.com/civicrm/civicrm-wordpress/pull/192))**

  This resolves issues with tracking URLs via the `wp-rest` endpoint that are
  then modified with `hook_civicrm_alterExternUrl`.

## <a name="misc"></a>Miscellany

- **Handle less common dynamic reference cases
  ([17653](https://github.com/civicrm/civicrm-core/pull/17653))**

- **Use apiv4, cache infra for basicTypes
  ([17387](https://github.com/civicrm/civicrm-core/pull/17387))**

- **Cleanup PriceFieldValue BAO
  ([17306](https://github.com/civicrm/civicrm-core/pull/17306))**

- **Clarify definition of amount field in civicrm_contribution_recur table.
  ([17311](https://github.com/civicrm/civicrm-core/pull/17311))**

- **Call completeOrder directly from contribute status update form
  ([17347](https://github.com/civicrm/civicrm-core/pull/17347))**

- **Switch docblock code to use markdown syntax.
  ([17304](https://github.com/civicrm/civicrm-core/pull/17304))**

- **Preliminary cleanup on form
  ([17345](https://github.com/civicrm/civicrm-core/pull/17345))**

- **Add getBAOClassName utiltiy function
  ([17268](https://github.com/civicrm/civicrm-core/pull/17268))**

- **CRM/Logging - Remove obsolete cache static clear in test
  ([17269](https://github.com/civicrm/civicrm-core/pull/17269))**

- **Remove incorrect retrievals of tax-term setting
  ([17183](https://github.com/civicrm/civicrm-core/pull/17183))**

- **CiviEvent Dashboard and Manage Events: clean up disused url template vars
  ([17378](https://github.com/civicrm/civicrm-core/pull/17378))**

- **Set default using spec for activity_date_time
  ([17390](https://github.com/civicrm/civicrm-core/pull/17390))**

- **Convert remaining Authorize.net test to use guzzle
  ([17473](https://github.com/civicrm/civicrm-core/pull/17473))**

- **Various BAO create/add cleanups to use writeRecord()
  ([17308](https://github.com/civicrm/civicrm-core/pull/17308))**

- **Remove instantiation of transaction from payment express ipn class
  ([17348](https://github.com/civicrm/civicrm-core/pull/17348))**

- **Remove null code
  ([17381](https://github.com/civicrm/civicrm-core/pull/17381))**

- **Remove validation bypass
  ([17384](https://github.com/civicrm/civicrm-core/pull/17384))**

- **Simplify recurring contribution template inheritance
  ([17178](https://github.com/civicrm/civicrm-core/pull/17178))**

- **Remove $_REQUEST passed into CRM_Utils_Request::retrieve NFC
  ([17377](https://github.com/civicrm/civicrm-core/pull/17377))**

- **Use now instead of date for activity API3 spec
  ([17411](https://github.com/civicrm/civicrm-core/pull/17411))**

- **Typo Fix ([17409](https://github.com/civicrm/civicrm-core/pull/17409))**

- **Fix logic for job log cleanup and make SQL safer
  ([17203](https://github.com/civicrm/civicrm-core/pull/17203))**

- **Remove always-true if block.
  ([17415](https://github.com/civicrm/civicrm-core/pull/17415))**

- **Remove No longer required HTTP_Request Package
  ([293](https://github.com/civicrm/civicrm-packages/pull/293))**

- **Remove code that still seems unnecessary.
  ([17342](https://github.com/civicrm/civicrm-core/pull/17342))**

- **Undo variable variable.
  ([17371](https://github.com/civicrm/civicrm-core/pull/17371))**

- **Use non-deprecated method
  ([17370](https://github.com/civicrm/civicrm-core/pull/17370))**

- **Remove last reference to Payment->_processorName in core & remove from
  processors ([17474](https://github.com/civicrm/civicrm-core/pull/17474))**

- **Remove unused singleton from core payment processors
  ([17468](https://github.com/civicrm/civicrm-core/pull/17468))**

- **Test fixes to support apiv4 add of MembershipType
  ([17488](https://github.com/civicrm/civicrm-core/pull/17488))**

- **Merge code - remove UPDATE IGNORE+Delete & just use reliable update
  ([17072](https://github.com/civicrm/civicrm-core/pull/17072))**

- **Remove unneeded parameters in {ts} on membership form
  ([17326](https://github.com/civicrm/civicrm-core/pull/17326))**

- **Remove unused 'reset' param, other NFC tidy up:
  ([17392](https://github.com/civicrm/civicrm-core/pull/17392))**

- **Fix setLanguage docblock, other nfc changes
  ([17356](https://github.com/civicrm/civicrm-core/pull/17356))**

- **[REF] Simplify contributionIDs code
  ([17441](https://github.com/civicrm/civicrm-core/pull/17441))**

- **[REF] Extract getAttachments
  ([17405](https://github.com/civicrm/civicrm-core/pull/17405))**

- **[REF] Preliminary cleanup for #17339
  ([17417](https://github.com/civicrm/civicrm-core/pull/17417))**

- **[REF] Remove unreachable block.
  ([17407](https://github.com/civicrm/civicrm-core/pull/17407))**

- **[REF] Pass an array of correct params to the function to create a recurring
  contribution. ([17398](https://github.com/civicrm/civicrm-core/pull/17398))**

- **[REF] Code simplification & unit test on suppressed emails in task
  ([17393](https://github.com/civicrm/civicrm-core/pull/17393))**

- **[REF] duplicate function.
  ([17400](https://github.com/civicrm/civicrm-core/pull/17400))**

- **[REF] Pass params not-by-reference
  ([17406](https://github.com/civicrm/civicrm-core/pull/17406))**

- **[REF] Refactor to switch from pear HTTP Request class to using Guzzle
  ([17420](https://github.com/civicrm/civicrm-core/pull/17420))**

- **[REF] [Reports] Ensure that all contribution pages including disabled ones
  are return… ([17357](https://github.com/civicrm/civicrm-core/pull/17357))**

- **[REF] Cleanup and extract string functions specific to entity names.
  ([17330](https://github.com/civicrm/civicrm-core/pull/17330))**

- **[REF] Stop passing  by reference.
  ([17349](https://github.com/civicrm/civicrm-core/pull/17349))**

- **[REF] Simplify subject code.
  ([17436](https://github.com/civicrm/civicrm-core/pull/17436))**

- **[REF] Implement required fields database changes that have occured du…
  ([17465](https://github.com/civicrm/civicrm-core/pull/17465), [17725](https://github.com/civicrm/civicrm-core/pull/17725))**

- **[REF] Bump Pear Log version to fix compatability with Drupal 8 / Drup…
  ([17460](https://github.com/civicrm/civicrm-core/pull/17460))**

- **[REF] Convert one of the http calls in Authorize.net class to use guzzle.
  ([17449](https://github.com/civicrm/civicrm-core/pull/17449))**

- **[REF] Minor simplification
  ([17443](https://github.com/civicrm/civicrm-core/pull/17443))**

- **[REF] Grant BAO cleanup
  ([17264](https://github.com/civicrm/civicrm-core/pull/17264))**

- **[REF] CRM_Core_DAO_AllCoreTables::getBriefName to accept BAO name
  ([17331](https://github.com/civicrm/civicrm-core/pull/17331))**

- **[REF] Missing semicolon on smtp settings page, code cleanup in file-on-case,
  add test ([17335](https://github.com/civicrm/civicrm-core/pull/17335))**

- **[REF] Extract createFollowUpActivities
  ([17481](https://github.com/civicrm/civicrm-core/pull/17481))**

- **[REF] Switch to an api call to get the contact details.
  ([17442](https://github.com/civicrm/civicrm-core/pull/17442))**

- **[REF] Minor code simplification
  ([17373](https://github.com/civicrm/civicrm-core/pull/17373))**

- **[REF] Call completeOrder directly from event status update form
  ([17346](https://github.com/civicrm/civicrm-core/pull/17346))**

- **[REF] Remove never-passed params from function signature
  ([17464](https://github.com/civicrm/civicrm-core/pull/17464))**

- **[REF] Fix serialized membership field handling in RelationshipTest
  ([17469](https://github.com/civicrm/civicrm-core/pull/17469))**

- **[REF] Minor tidy up
  ([17302](https://github.com/civicrm/civicrm-core/pull/17302))**

- **[REF] Remove always NULL param modified_id
  ([17489](https://github.com/civicrm/civicrm-core/pull/17489))**

- **[REF] Add contribution_id field to search using metadata instead of h…
  ([17286](https://github.com/civicrm/civicrm-core/pull/17286))**

- **[REF] Fix unit test failures on MySQL 5.6 due to Custom Field table being
  created without Dynamic Row Format
  ([17586](https://github.com/civicrm/civicrm-core/pull/17586))**

- **[REF] Start to convert Dummy processor to use PropertyBag
  ([17452](https://github.com/civicrm/civicrm-core/pull/17452))**

- **[Ref] remove calls to, and deprecate, pending function
  ([17490](https://github.com/civicrm/civicrm-core/pull/17490))**

- **[REF] Cleanup MailingAB BAO
  ([17309](https://github.com/civicrm/civicrm-core/pull/17309))**

- **[TEST] Update test to support for 8.0.19 change
  ([17354](https://github.com/civicrm/civicrm-core/pull/17354))**

- **[TEST] Fix test failure on Drupal 8 E2E PrevNextTest by only includin…
  ([17358](https://github.com/civicrm/civicrm-core/pull/17358))**

- **[TEST] dev/core#1766 - Remove flakiness from testGetFromTo tests
  ([dev/core#1766](https://lab.civicrm.org/dev/core/-/issues/1766):
  [17338](https://github.com/civicrm/civicrm-core/pull/17338))**

- **[NFC/TEST] dev/core#1784 - Unit tests for contact delete/restore
  ([dev/core#1784](https://lab.civicrm.org/dev/core/-/issues/1784):
  [17437](https://github.com/civicrm/civicrm-core/pull/17437))**

- **NFC - Change array() to short syntax []
  ([17470](https://github.com/civicrm/civicrm-core/pull/17470))**

- **[NFC] Update Karma to be latest version
  ([17439](https://github.com/civicrm/civicrm-core/pull/17439))**

- **(NFC) CRM_Utils_Url - Fix declared type
  ([17320](https://github.com/civicrm/civicrm-core/pull/17320))**

- **[NFC] Remove some more of the old  cvs blocks
  ([17383](https://github.com/civicrm/civicrm-core/pull/17383))**

- **NFC Add a bit more clarity to createEmailActivity function
  ([17391](https://github.com/civicrm/civicrm-core/pull/17391))**

- **[NFC] Add comment that deprecated code is actually still reachable
  ([17340](https://github.com/civicrm/civicrm-core/pull/17340))**

- **(NFC) Remove some cvs docblock help
  ([17322](https://github.com/civicrm/civicrm-core/pull/17322))**

- **[NFC] Add comment regarding lower case for Polish states
  ([17327](https://github.com/civicrm/civicrm-core/pull/17327))**

- **(NFC) RegionTest - Small cleanups
  ([17270](https://github.com/civicrm/civicrm-core/pull/17270))**

- **[NFC] Add sr-only class for content only for screen readers
  ([17255](https://github.com/civicrm/civicrm-core/pull/17255))**

- **NFC Change hardcoded ID to constant
  ([17275](https://github.com/civicrm/civicrm-core/pull/17275))**

- **[NFC] Fix use of single quotes, strict operator
  ([17492](https://github.com/civicrm/civicrm-core/pull/17492))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

a-n The Artists Information Company - William Mortada; AGH Strategies - Alice
Frumin, Andrew Hunt; Andrei Mondoc; British Humanist Association - Andrew West;
Caltha - Tomasz Pietrzkowski; Christian Wach; Circle Interactive - Pradeep
Nayak; CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Yashodha Chaku;
CompuCorp - René Olivo; Coop SymbioTIC - Mathieu Lutfy; Dave D; Dominic Hargreaves;
Electronic Frontier Foundation - Mark Burdett; Freeform Solutions - Herb van den
Dool; Fuzion - Jitendra Purohit; Greenpeace Central and Eastern Europe - Patrick
Figel; JMA Consulting - Edsel Lopez, Seamus Lee; John Kingsnorth; Joinery -
Allen Shaw; Kartik Kathuria; Lighthouse Design and Consulting - Brian
Shaughnessy; Megaphone Technology Consulting - Jon Goldberg; MJCO - Mikey
O'Toole; MJW Consulting - Matthew Wire; Palante Technology Cooperative - Morgan
Robinson; Semper IT - Karin Gerritsen; Tadpole Collective - Kevin Cristiano;
Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Justin Freeman; Artful Robot - Rich Lott; Betty Dolfing; CiviCoop -
Jaap Jansma; iXiam - Luciano Spiegel; JMA Consulting - Monish Deb; Kartik
Kathuria; Korlon - Stuart Gaston; Megaphone Technology Consulting - Dennis P.
Osorio; Squiffle Consulting - Aidan Saunders

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andrew Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
