#!/bin/sh

#BEGIN DEPEND------------------------------------------------------------------
INPUT_FLAGS_MODULE=src/lib/perl5/COD/CIF/Data/CODFlags.pm
INPUT_MANAGE_MODULE=src/lib/perl5/COD/CIF/Tags/Manage.pm
#END DEPEND--------------------------------------------------------------------

IMPORT_FLAGS_MODULE=$(\
    echo ${INPUT_FLAGS_MODULE} | \
    perl -pe "s|^src/lib/perl5/||; s/[.]pm$//; s|/|::|g;" \
)

IMPORT_MANAGE_MODULE=$(\
    echo ${INPUT_MANAGE_MODULE} | \
    perl -pe "s|^src/lib/perl5/||; s/[.]pm$//; s|/|::|g;" \
)

perl -M"${IMPORT_FLAGS_MODULE}  qw( has_unmodelled_solvent_molecules )" \
     -M"${IMPORT_MANAGE_MODULE} qw( new_datablock )" \
<<'END_SCRIPT'
#------------------------------------------------------------------------------
#$Author: antanas $
#$Date: 2024-05-26 17:12:38 +0300 (Sun, 26 May 2024) $
#$Revision: 10066 $
#$URL: svn+ssh://www.crystallography.net/home/coder/svn-repositories/cod-tools/tags/v3.10.0/tests/shtests/has_unmodelled_solvent_molecules_003.sh $
#------------------------------------------------------------------------------
#* Unit test for the COD::CIF::Data::CODFlags::has_unmodelled_solvent_molecules()
#* subroutine. Test the way the '_platon_squeeze_void_count_electrons'
#* data item that appears as part of the '_shelx_fab_file' data item
#* value is recognised and handled.
#**

use strict;
use warnings;

# use COD::CIF::Data::CODFlags qw( has_unmodelled_solvent_molecules );
# use COD::CIF::Tags::Manage qw( new_datablock );

my @data_blocks;
my $data_block;

# Contains no data about unmodelled solvent molecules.
$data_block = new_datablock( '[NO]_empty' );
push @data_blocks, $data_block;

# Contains the '_shelx_fab_file' data item.
# Value of the '_shelx_fab_file' data item does not contain
# the '_platon_squeeze_void_count_electrons' string.
$data_block = new_datablock( '[NO]_shelx_fab_file_no_platon_squeeze' );
$data_block->{'values'}{'_shelx_fab_file'} = [ 'Fab file contents' ];
push @data_blocks, $data_block;

# Contains the '_shelx_fab_file' data item.
# The single line value of the '_shelx_fab_file' data item
# contains the '_platon_squeeze_void_count_electrons' string.
$data_block = new_datablock( '[YES]_single_line_shelx_fab_file_with_platon_squeeze' );
$data_block->{'values'}{'_shelx_fab_file'} = [
    '_platon_squeeze_void_count_electrons'
];
push @data_blocks, $data_block;

# Contains the '_shelx_fab_file' data item.
# The multiline value of the '_shelx_fab_file' data item
# contains the '_platon_squeeze_void_count_electrons' string.
$data_block = new_datablock( '[YES]_multiline_shelx_fab_file_with_platon_squeeze' );
$data_block->{'values'}{'_shelx_fab_file'} = [
    (
        "Fab file with\n" .
        "the _platon_squeeze_void_count_electrons tag\n" .
        "on another line"
    )
];
push @data_blocks, $data_block;

print "Output\tData block name\n";
for my $test_case (@data_blocks) {
    print has_unmodelled_solvent_molecules($test_case) . "\t" . $test_case->{'name'} . "\n";
}

END_SCRIPT
