package org.apache.commons.javaflow.bytecode.transformation.tests;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import junitx.util.PrivateAccessor;
import org.apache.commons.javaflow.Continuation;
import org.apache.commons.javaflow.bytecode.transformation.AbstractTransformerTestCase;
import org.apache.commons.javaflow.bytecode.transformation.Invoker;
import org.apache.commons.javaflow.bytecode.transformation.data.Simple;
import org.apache.commons.javaflow.bytecode.transformation.data.SimpleSerializable;
import org.apache.tools.ant.util.FileUtils;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;

public abstract class AbstractSerializationTestCase extends AbstractTransformerTestCase {

    private File output;


    public void testSuspend() throws Exception {
        final SimpleSerializable r = new SimpleSerializable();
        assertTrue(r.g == -1);
        assertTrue(r.l == -1);
        Continuation c1 = Continuation.startWith(r);
        assertTrue(r.g == 0);
        assertTrue(r.l == 0);
        final XStream xstream = new XStream(new DomDriver());
        final String xml = xstream.toXML(c1);
        output = File.createTempFile("continuation", "xml");
        output.deleteOnExit();
        final FileOutputStream fos = new FileOutputStream(output);
        fos.write(xml.getBytes());
    }


    public void testResume() throws Exception {
        testSuspend();
        assertTrue("suspend must succeed to create the output first", output != null);
        final String xml = FileUtils.readFully(new FileReader(output));
        final XStream xstream = new XStream(new DomDriver());
        final Object o = xstream.fromXML(xml);
        assertTrue(o instanceof Continuation);
        final Continuation c1 = (Continuation) o;
        final SimpleSerializable r1 = (SimpleSerializable) PrivateAccessor.getField(PrivateAccessor
                .getField(c1, "stackRecorder"), "runnable");
        assertTrue(r1.g == 0);
        assertTrue(r1.l == 0);
        final Continuation c2 = Continuation.continueWith(c1);
        final SimpleSerializable r2 = (SimpleSerializable) PrivateAccessor.getField(PrivateAccessor
                .getField(c1, "stackRecorder"), "runnable");
        assertTrue(r2.g == 1);
        assertTrue(r2.l == 1);
        assertTrue(r1 == r2);
    }


    public void testSerializableCheck() throws Exception {
        final Runnable r1 = new Simple();
        Continuation c1 = Continuation.startWith(r1);
        assertTrue(c1 != null);
        assertTrue(!c1.isSerializable());
        final Runnable r2 = new SimpleSerializable();
        Continuation c2 = Continuation.startWith(r2);
        assertTrue(c2 != null);
        assertTrue(c2.isSerializable());
        final Runnable r3 = new SimpleSerializable();
        Continuation c3 = Continuation.startWith(new Invoker(r3));
        assertTrue(c3 != null);
        assertTrue(c3.isSerializable());
    }
}
