/* $Id: hdrl_image.h,v 1.2 2013-10-16 16:52:20 cgarcia Exp $
 *
 * This file is part of the HDRL
 * Copyright (C) 2013 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author: cgarcia $
 * $Date: 2013-10-16 16:52:20 $
 * $Revision: 1.2 $
 * $Name: not supported by cvs2svn $
 */

#ifndef HDRL_IMAGE_H
#define HDRL_IMAGE_H

/*-----------------------------------------------------------------------------
                                   New types
 -----------------------------------------------------------------------------*/

typedef struct _hdrl_image_ hdrl_image;

/*----------------------------------------------------------------------------*/
/**
 * @defgroup hdrl_image HDRL Image
 *
 * This module provides functions to create, use, and destroy an
 *   @em hdrl_image.
 * 
 * @par Synopsis:
 * @code
 *   #include "hdrl_imagelh"
 * @endcode
 */
/*----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include "hdrl_image_math.h"
#include "hdrl_utils.h"

#include <cpl.h>

/*-----------------------------------------------------------------------------
                                   Functions
 -----------------------------------------------------------------------------*/

CPL_BEGIN_DECLS
hdrl_image * hdrl_image_new(cpl_size nx, cpl_size ny);

hdrl_image * hdrl_image_create(const cpl_image * image,
                               const cpl_image * error);

hdrl_image * hdrl_image_duplicate(const hdrl_image * himg);

void hdrl_image_delete(hdrl_image * himg);

double hdrl_image_get_pixel(const hdrl_image * self,
                            cpl_size xpos, cpl_size ypos,
                            double * error, int * pis_rejected);

cpl_error_code hdrl_image_set_pixel(hdrl_image * self,
                                    cpl_size xpos, cpl_size ypos,
                                    double value, double error);

cpl_size hdrl_image_get_size_x(const hdrl_image * self) ;
cpl_size hdrl_image_get_size_y(const hdrl_image * self) ;

hdrl_image * hdrl_image_extract(const hdrl_image *, const hdrl_parameter *) ;

cpl_error_code hdrl_image_reject(hdrl_image * self,
                                 cpl_size xpos, cpl_size ypos);
cpl_error_code hdrl_image_reject_value(hdrl_image * self, cpl_value mode);

cpl_error_code hdrl_image_copy(hdrl_image * other, const hdrl_image * self,
                               cpl_size xpos, cpl_size ypos);
CPL_END_DECLS

#ifdef HDRL_USE_PRIVATE
hdrl_image * hdrl_image_wrap(cpl_image * img, cpl_image * err);
void hdrl_image_unwrap(hdrl_image * himg);
#endif

#endif 
